/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.spi;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Key;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.ElementVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.ProviderWithDependencies;
import io.quarkus.launcher.shaded.com.google.inject.util.Types;
import java.util.Set;

public final class ProviderLookup<T>
implements Element {
    private final Object source;
    private final Dependency<T> dependency;
    private Provider<T> delegate;

    public ProviderLookup(Object source, Key<T> key) {
        this(source, Dependency.get(Preconditions.checkNotNull(key, "io.quarkus.launcher.shaded.key")));
    }

    public ProviderLookup(Object source, Dependency<T> dependency) {
        this.source = Preconditions.checkNotNull(source, "io.quarkus.launcher.shaded.source");
        this.dependency = Preconditions.checkNotNull(dependency, "io.quarkus.launcher.shaded.dependency");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.dependency.getKey();
    }

    public Dependency<T> getDependency() {
        return this.dependency;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(Provider<T> delegate) {
        Preconditions.checkState(this.delegate == null, "io.quarkus.launcher.shaded.delegate already initialized");
        this.delegate = Preconditions.checkNotNull(delegate, "io.quarkus.launcher.shaded.delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getProvider(this.dependency));
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    public Provider<T> getProvider() {
        return new ProviderWithDependencies<T>(){

            @Override
            public T get() {
                Provider local = ProviderLookup.this.delegate;
                if (local == null) {
                    throw new IllegalStateException("io.quarkus.launcher.shaded.This Provider cannot be used until the Injector has been created.");
                }
                return local.get();
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                Key<?> providerKey = ProviderLookup.this.getKey().ofType(Types.providerOf(ProviderLookup.this.getKey().getTypeLiteral().getType()));
                return ImmutableSet.of(Dependency.get(providerKey));
            }

            public String toString() {
                return "io.quarkus.launcher.shaded.Provider<" + ProviderLookup.this.getKey().getTypeLiteral() + "io.quarkus.launcher.shaded.>";
            }
        };
    }
}

