/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.spi;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.Scope;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.ElementVisitor;
import java.lang.annotation.Annotation;

public final class ScopeBinding
implements Element {
    private final Object source;
    private final Class<? extends Annotation> annotationType;
    private final Scope scope;

    ScopeBinding(Object source, Class<? extends Annotation> annotationType, Scope scope) {
        this.source = Preconditions.checkNotNull(source, "io.quarkus.launcher.shaded.source");
        this.annotationType = Preconditions.checkNotNull(annotationType, "io.quarkus.launcher.shaded.annotationType");
        this.scope = Preconditions.checkNotNull(scope, "io.quarkus.launcher.shaded.scope");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    public Scope getScope() {
        return this.scope;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindScope(this.annotationType, this.scope);
    }
}

