/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.spi;

import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.inject.Binder;
import io.quarkus.launcher.shaded.com.google.inject.TypeLiteral;
import io.quarkus.launcher.shaded.com.google.inject.internal.Errors;
import io.quarkus.launcher.shaded.com.google.inject.matcher.Matcher;
import io.quarkus.launcher.shaded.com.google.inject.spi.Element;
import io.quarkus.launcher.shaded.com.google.inject.spi.ElementVisitor;
import io.quarkus.launcher.shaded.com.google.inject.spi.TypeConverter;

public final class TypeConverterBinding
implements Element {
    private final Object source;
    private final Matcher<? super TypeLiteral<?>> typeMatcher;
    private final TypeConverter typeConverter;

    public TypeConverterBinding(Object source, Matcher<? super TypeLiteral<?>> typeMatcher, TypeConverter typeConverter) {
        this.source = Preconditions.checkNotNull(source, "io.quarkus.launcher.shaded.source");
        this.typeMatcher = Preconditions.checkNotNull(typeMatcher, "io.quarkus.launcher.shaded.typeMatcher");
        this.typeConverter = Preconditions.checkNotNull(typeConverter, "io.quarkus.launcher.shaded.typeConverter");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Matcher<? super TypeLiteral<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).convertToTypes(this.typeMatcher, this.typeConverter);
    }

    public String toString() {
        return this.typeConverter + "io.quarkus.launcher.shaded. which matches " + this.typeMatcher + "io.quarkus.launcher.shaded. (bound at " + Errors.convert(this.source) + "io.quarkus.launcher.shaded.)";
    }
}

