/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.com.google.inject.util;

import io.quarkus.launcher.shaded.com.google.common.base.Objects;
import io.quarkus.launcher.shaded.com.google.common.base.Preconditions;
import io.quarkus.launcher.shaded.com.google.common.collect.ImmutableSet;
import io.quarkus.launcher.shaded.com.google.common.collect.Sets;
import io.quarkus.launcher.shaded.com.google.inject.Inject;
import io.quarkus.launcher.shaded.com.google.inject.Injector;
import io.quarkus.launcher.shaded.com.google.inject.Provider;
import io.quarkus.launcher.shaded.com.google.inject.spi.Dependency;
import io.quarkus.launcher.shaded.com.google.inject.spi.InjectionPoint;
import io.quarkus.launcher.shaded.com.google.inject.spi.ProviderWithDependencies;
import java.util.HashSet;
import java.util.Set;

public final class Providers {
    private Providers() {
    }

    public static <T> Provider<T> of(T instance) {
        return new ConstantProvider(instance);
    }

    public static <T> Provider<T> guicify(io.quarkus.launcher.shaded.javax.inject.Provider<T> provider) {
        if (provider instanceof Provider) {
            return (Provider)provider;
        }
        io.quarkus.launcher.shaded.javax.inject.Provider<T> delegate = Preconditions.checkNotNull(provider, "io.quarkus.launcher.shaded.provider");
        Set<InjectionPoint> injectionPoints = InjectionPoint.forInstanceMethodsAndFields(provider.getClass());
        if (injectionPoints.isEmpty()) {
            return new GuicifiedProvider(delegate);
        }
        HashSet<Dependency<?>> mutableDeps = Sets.newHashSet();
        for (InjectionPoint ip : injectionPoints) {
            mutableDeps.addAll(ip.getDependencies());
        }
        ImmutableSet dependencies = ImmutableSet.copyOf(mutableDeps);
        return new GuicifiedProviderWithDependencies(dependencies, delegate);
    }

    private static final class GuicifiedProviderWithDependencies<T>
    extends GuicifiedProvider<T>
    implements ProviderWithDependencies<T> {
        private final Set<Dependency<?>> dependencies;

        private GuicifiedProviderWithDependencies(Set<Dependency<?>> dependencies, io.quarkus.launcher.shaded.javax.inject.Provider<T> delegate) {
            super(delegate);
            this.dependencies = dependencies;
        }

        @Inject
        void initialize(Injector injector) {
            injector.injectMembers(this.delegate);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.dependencies;
        }
    }

    private static class GuicifiedProvider<T>
    implements Provider<T> {
        protected final io.quarkus.launcher.shaded.javax.inject.Provider<T> delegate;

        private GuicifiedProvider(io.quarkus.launcher.shaded.javax.inject.Provider<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public T get() {
            return (T)this.delegate.get();
        }

        public String toString() {
            return "io.quarkus.launcher.shaded.guicified(" + this.delegate + "io.quarkus.launcher.shaded.)";
        }

        public boolean equals(Object obj) {
            return obj instanceof GuicifiedProvider && Objects.equal(this.delegate, ((GuicifiedProvider)obj).delegate);
        }

        public int hashCode() {
            return Objects.hashCode(this.delegate);
        }
    }

    private static final class ConstantProvider<T>
    implements Provider<T> {
        private final T instance;

        private ConstantProvider(T instance) {
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public String toString() {
            return "io.quarkus.launcher.shaded.of(" + this.instance + "io.quarkus.launcher.shaded.)";
        }

        public boolean equals(Object obj) {
            return obj instanceof ConstantProvider && Objects.equal(this.instance, ((ConstantProvider)obj).instance);
        }

        public int hashCode() {
            return Objects.hashCode(this.instance);
        }
    }
}

