/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.io.quarkus.bootstrap.BootstrapException;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.model.AppArtifact;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.BootstrapMavenContextConfig;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.BootstrapWagonConfigurator;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.BootstrapWagonProvider;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.SettingsDecrypterImpl;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.StringUtils;
import io.quarkus.launcher.shaded.org.apache.maven.cli.transfer.ConsoleMavenTransferListener;
import io.quarkus.launcher.shaded.org.apache.maven.model.Model;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.DefaultPathTranslator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.DefaultProfileActivationContext;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.DefaultProfileSelector;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.FileProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.PropertyProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.SettingsUtils;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositoryCache;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystem;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.DefaultArtifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.RemoteRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.internal.impl.DefaultRemoteRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Authentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactDescriptorException;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonConfigurator;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import io.quarkus.launcher.shaded.org.jboss.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.function.Supplier;

public class BootstrapMavenContext {
    private static final Logger log = Logger.getLogger(BootstrapMavenContext.class);
    private static final String BASEDIR = "io.quarkus.launcher.shaded.basedir";
    private static final String DEFAULT_REMOTE_REPO_ID = "io.quarkus.launcher.shaded.central";
    private static final String DEFAULT_REMOTE_REPO_URL = "io/quarkus/launcher/shaded/https://repo.maven.apache.org/maven2";
    private static final String MAVEN_DOT_HOME = "io.quarkus.launcher.shaded.maven.home";
    private static final String MAVEN_HOME = "io.quarkus.launcher.shaded.MAVEN_HOME";
    private static final String MAVEN_PROJECTBASEDIR = "io.quarkus.launcher.shaded.MAVEN_PROJECTBASEDIR";
    private static final String SETTINGS_XML = "io.quarkus.launcher.shaded.settings.xml";
    private static final String userHome = PropertyUtils.getUserHome();
    private static final File userMavenConfigurationHome = new File(userHome, "io.quarkus.launcher.shaded..m2");
    private boolean artifactTransferLogging;
    private BootstrapMavenOptions cliOptions;
    private File userSettings;
    private File globalSettings;
    private Boolean offline;
    private LocalWorkspace workspace;
    private LocalProject currentProject;
    private Settings settings;
    private List<Profile> activeSettingsProfiles;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    private String localRepo;
    private Path currentPom;
    private Boolean currentProjectExists;
    private DefaultServiceLocator serviceLocator;
    private String alternatePomName;

    public static BootstrapMavenContextConfig<?> config() {
        return new BootstrapMavenContextConfig();
    }

    public BootstrapMavenContext() throws AppModelResolverException {
        this(new BootstrapMavenContextConfig());
    }

    public BootstrapMavenContext(BootstrapMavenContextConfig<?> config) throws AppModelResolverException {
        this.alternatePomName = config.alternativePomName;
        this.artifactTransferLogging = config.artifactTransferLogging;
        this.localRepo = config.localRepo;
        this.offline = config.offline;
        this.repoSystem = config.repoSystem;
        this.repoSession = config.repoSession;
        this.remoteRepos = config.remoteRepos;
        if (config.currentProject != null) {
            this.currentProject = config.currentProject;
            this.currentPom = this.currentProject.getRawModel().getPomFile().toPath();
            this.workspace = config.currentProject.getWorkspace();
        } else if (config.workspaceDiscovery) {
            this.currentProject = this.resolveCurrentProject();
            this.workspace = this.currentProject == null ? null : this.currentProject.getWorkspace();
        }
        this.userSettings = config.userSettings == null ? BootstrapMavenContext.resolveSettingsFile(this.getCliOptions().getOptionValue("io.quarkus.launcher.shaded.s"), () -> new File(userMavenConfigurationHome, SETTINGS_XML)) : config.userSettings;
        this.globalSettings = BootstrapMavenContext.resolveSettingsFile(this.getCliOptions().getOptionValue("io.quarkus.launcher.shaded.gs"), () -> {
            String envM2Home = System.getenv(MAVEN_HOME);
            return new File(PropertyUtils.getProperty(MAVEN_DOT_HOME, envM2Home != null ? envM2Home : "io.quarkus.launcher.shaded."), "io/quarkus/launcher/shaded/conf/settings.xml");
        });
    }

    public AppArtifact getCurrentProjectArtifact(String extension) throws AppModelResolverException {
        if (this.currentProject != null) {
            return this.currentProject.getAppArtifact(extension);
        }
        Model model = this.loadCurrentProjectModel();
        if (model == null) {
            return null;
        }
        return new AppArtifact(ModelUtils.getGroupId(model), model.getArtifactId(), "io.quarkus.launcher.shaded.", extension, ModelUtils.getVersion(model));
    }

    public LocalProject getCurrentProject() {
        return this.currentProject;
    }

    public LocalWorkspace getWorkspace() {
        return this.workspace;
    }

    public BootstrapMavenOptions getCliOptions() {
        return this.cliOptions == null ? (this.cliOptions = BootstrapMavenOptions.newInstance()) : this.cliOptions;
    }

    public File getUserSettings() {
        return this.userSettings;
    }

    public File getGlobalSettings() {
        return this.globalSettings;
    }

    public boolean isOffline() throws AppModelResolverException {
        return this.offline == null ? (this.offline = Boolean.valueOf(this.getCliOptions().hasOption("io.quarkus.launcher.shaded.o") || this.getEffectiveSettings().isOffline())) : this.offline;
    }

    public RepositorySystem getRepositorySystem() throws AppModelResolverException {
        return this.repoSystem == null ? (this.repoSystem = this.newRepositorySystem()) : this.repoSystem;
    }

    public RepositorySystemSession getRepositorySystemSession() throws AppModelResolverException {
        return this.repoSession == null ? (this.repoSession = this.newRepositorySystemSession()) : this.repoSession;
    }

    public List<RemoteRepository> getRemoteRepositories() throws AppModelResolverException {
        return this.remoteRepos == null ? (this.remoteRepos = this.resolveRemoteRepos()) : this.remoteRepos;
    }

    public Settings getEffectiveSettings() throws AppModelResolverException {
        Settings effectiveSettings;
        if (this.settings != null) {
            return this.settings;
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build(new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(this.getUserSettings()).setGlobalSettingsFile(this.getGlobalSettings()));
            List<SettingsProblem> problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new AppModelResolverException("io.quarkus.launcher.shaded.Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("io.quarkus.launcher.shaded.Settings problem encountered at " + problem.getLocation()), problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new AppModelResolverException("io.quarkus.launcher.shaded.Failed to initialize Maven repository settings", e);
        }
        this.settings = effectiveSettings;
        return this.settings;
    }

    public String getLocalRepo() throws AppModelResolverException {
        return this.localRepo == null ? (this.localRepo = BootstrapMavenContext.resolveLocalRepo(this.getEffectiveSettings())) : this.localRepo;
    }

    private LocalProject resolveCurrentProject() throws AppModelResolverException {
        try {
            return LocalProject.loadWorkspace(this);
        }
        catch (BootstrapException e) {
            throw new AppModelResolverException("io.quarkus.launcher.shaded.Failed to load current project at " + this.getCurrentProjectPomOrNull(), e);
        }
    }

    public static String resolveLocalRepo(Settings settings) {
        String localRepo = System.getenv("io.quarkus.launcher.shaded.QUARKUS_LOCAL_REPO");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = PropertyUtils.getProperty("io.quarkus.launcher.shaded.maven.repo.local");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = settings.getLocalRepository();
        return localRepo == null ? new File(userMavenConfigurationHome, "io.quarkus.launcher.shaded.repository").getAbsolutePath() : localRepo;
    }

    private static File resolveSettingsFile(String settingsArg, Supplier<File> supplier) {
        File userSettings;
        if (settingsArg != null) {
            userSettings = new File(settingsArg);
            if (userSettings.exists()) {
                return userSettings;
            }
            String base = System.getenv(MAVEN_PROJECTBASEDIR);
            if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
                return userSettings;
            }
            base = PropertyUtils.getProperty(BASEDIR);
            if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
                return userSettings;
            }
            userSettings = new File(PropertyUtils.getUserHome(), settingsArg);
            if (userSettings.exists()) {
                return userSettings;
            }
        }
        return (userSettings = supplier.get()).exists() ? userSettings : null;
    }

    private DefaultRepositorySystemSession newRepositorySystemSession() throws AppModelResolverException {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        Settings settings = this.getEffectiveSettings();
        List<Mirror> mirrors = settings.getMirrors();
        if (mirrors != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector(ms);
        }
        String localRepoPath = this.getLocalRepo();
        session.setLocalRepositoryManager(this.getRepositorySystem().newLocalRepositoryManager(session, new LocalRepository(localRepoPath)));
        session.setOffline(this.isOffline());
        BootstrapMavenOptions mvnArgs = this.getCliOptions();
        if (!mvnArgs.isEmpty()) {
            if (mvnArgs.hasOption("io.quarkus.launcher.shaded.nsu")) {
                session.setUpdatePolicy("io.quarkus.launcher.shaded.never");
            } else if (mvnArgs.hasOption("io.quarkus.launcher.shaded.U")) {
                session.setUpdatePolicy("io.quarkus.launcher.shaded.always");
            }
            if (mvnArgs.hasOption("io.quarkus.launcher.shaded.C")) {
                session.setChecksumPolicy("io.quarkus.launcher.shaded.fail");
            } else if (mvnArgs.hasOption("io.quarkus.launcher.shaded.c")) {
                session.setChecksumPolicy("io.quarkus.launcher.shaded.warn");
            }
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)settings.getProxies());
        decrypt.setServers((List)settings.getServers());
        SettingsDecryptionResult decrypted = new SettingsDecrypterImpl().decrypt(decrypt);
        if (!decrypted.getProblems().isEmpty() && log.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                log.debug((Object)settingsProblem.getMessage(), settingsProblem.getException());
            }
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Proxy p : decrypted.getProxies()) {
            proxySelector.add(BootstrapMavenContext.toAetherProxy(p), p.getNonProxyHosts());
        }
        session.setProxySelector(proxySelector);
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(session.getConfigProperties());
        linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.userAgent", BootstrapMavenContext.getUserAgent());
        linkedHashMap.put("io.quarkus.launcher.shaded.aether.interactive", settings.isInteractiveMode());
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"io.quarkus.launcher.shaded.wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.wagon.config." + server.getId(), config);
            }
            linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(authSelector);
        session.setConfigProperties(linkedHashMap);
        if (session.getCache() == null) {
            session.setCache(new DefaultRepositoryCache());
        }
        if (this.workspace != null) {
            session.setWorkspaceReader(this.workspace);
        }
        if (session.getTransferListener() == null && this.artifactTransferLogging) {
            session.setTransferListener(new ConsoleMavenTransferListener(System.out, true));
        }
        return session;
    }

    private List<RemoteRepository> resolveRemoteRepos() throws AppModelResolverException {
        ArrayList<RemoteRepository> rawRepos = new ArrayList<RemoteRepository>();
        this.getActiveSettingsProfiles().forEach(p -> BootstrapMavenContext.addProfileRepos(p, rawRepos));
        if (rawRepos.isEmpty() || !BootstrapMavenContext.includesDefaultRepo(rawRepos)) {
            rawRepos.add(BootstrapMavenContext.newDefaultRepository());
        }
        List<RemoteRepository> repos = this.getRepositorySystem().newResolutionRepositories(this.getRepositorySystemSession(), rawRepos);
        return this.workspace == null ? repos : this.resolveCurrentProjectRepos(repos);
    }

    public static RemoteRepository newDefaultRepository() {
        return new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, "io.quarkus.launcher.shaded.default", DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "io.quarkus.launcher.shaded.daily", "io.quarkus.launcher.shaded.warn")).setSnapshotPolicy(new RepositoryPolicy(false, "io.quarkus.launcher.shaded.daily", "io.quarkus.launcher.shaded.warn")).build();
    }

    private Model loadCurrentProjectModel() throws AppModelResolverException {
        Path pom = this.getCurrentProjectPomOrNull();
        if (pom == null) {
            return null;
        }
        try {
            return ModelUtils.readModel(pom);
        }
        catch (IOException e) {
            throw new AppModelResolverException("io.quarkus.launcher.shaded.Failed to parse " + pom, e);
        }
    }

    private List<RemoteRepository> resolveCurrentProjectRepos(List<RemoteRepository> repos) throws AppModelResolverException {
        List<RemoteRepository> rawRepos;
        Model model = this.loadCurrentProjectModel();
        if (model == null) {
            return repos;
        }
        DefaultArtifact projectArtifact = new DefaultArtifact(ModelUtils.getGroupId(model), model.getArtifactId(), "io.quarkus.launcher.shaded.", "io.quarkus.launcher.shaded.pom", ModelUtils.getVersion(model));
        try {
            rawRepos = this.getRepositorySystem().readArtifactDescriptor(this.getRepositorySystemSession(), new ArtifactDescriptorRequest().setArtifact(projectArtifact).setRepositories(repos)).getRepositories();
        }
        catch (ArtifactDescriptorException e) {
            throw new AppModelResolverException("io.quarkus.launcher.shaded.Failed to read artifact descriptor for " + projectArtifact, e);
        }
        return this.getRepositorySystem().newResolutionRepositories(this.getRepositorySystemSession(), rawRepos);
    }

    public List<Profile> getActiveSettingsProfiles() throws AppModelResolverException {
        if (this.activeSettingsProfiles != null) {
            return this.activeSettingsProfiles;
        }
        Settings settings = this.getEffectiveSettings();
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal == 0) {
            return Collections.emptyList();
        }
        List<Profile> modelProfiles = new ArrayList<Profile>(profilesTotal);
        for (io.quarkus.launcher.shaded.org.apache.maven.settings.Profile profile : settings.getProfiles()) {
            modelProfiles.add(SettingsUtils.convertFromSettingsProfile(profile));
        }
        BootstrapMavenOptions mvnArgs = this.getCliOptions();
        List<String> activeProfiles = mvnArgs.getActiveProfileIds();
        List<String> inactiveProfiles = mvnArgs.getInactiveProfileIds();
        Path currentPom = this.getCurrentProjectPomOrNull();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext().setActiveProfileIds(activeProfiles).setInactiveProfileIds(inactiveProfiles).setSystemProperties(System.getProperties()).setProjectDirectory(currentPom == null ? this.getCurrentProjectBaseDir().toFile() : currentPom.getParent().toFile());
        DefaultProfileSelector profileSelector = new DefaultProfileSelector().addProfileActivator(new PropertyProfileActivator()).addProfileActivator(new JdkVersionProfileActivator()).addProfileActivator(new OperatingSystemProfileActivator()).addProfileActivator(new FileProfileActivator().setPathTranslator(new DefaultPathTranslator()));
        modelProfiles = profileSelector.getActiveProfiles(modelProfiles, context, new ModelProblemCollector(){

            @Override
            public void add(ModelProblemCollectorRequest req) {
                log.error("io.quarkus.launcher.shaded.Failed to activate a Maven profile: " + req.getMessage());
            }
        });
        activeProfiles = settings.getActiveProfiles();
        if (!activeProfiles.isEmpty()) {
            for (String profileName : activeProfiles) {
                io.quarkus.launcher.shaded.org.apache.maven.settings.Profile profile = BootstrapMavenContext.getProfile(profileName, settings);
                if (profile == null) continue;
                modelProfiles.add(SettingsUtils.convertFromSettingsProfile(profile));
            }
        }
        this.activeSettingsProfiles = modelProfiles;
        return this.activeSettingsProfiles;
    }

    private static io.quarkus.launcher.shaded.org.apache.maven.settings.Profile getProfile(String name, Settings settings) throws AppModelResolverException {
        io.quarkus.launcher.shaded.org.apache.maven.settings.Profile profile = settings.getProfilesAsMap().get(name);
        if (profile == null) {
            BootstrapMavenContext.unrecognizedProfile(name, true);
        }
        return profile;
    }

    private static void unrecognizedProfile(String name, boolean activate) {
        StringBuilder buf = new StringBuilder();
        buf.append("io.quarkus.launcher.shaded.The requested Maven profile \"").append(name).append("io.quarkus.launcher.shaded.\" could not be ");
        if (!activate) {
            buf.append("io.quarkus.launcher.shaded.de");
        }
        buf.append("io.quarkus.launcher.shaded.activated because it does not exist.");
        log.warn(buf.toString());
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static void addProfileRepos(Profile profile, List<RemoteRepository> all) {
        List<Repository> repositories = profile.getRepositories();
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(BootstrapMavenContext.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(BootstrapMavenContext.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    private static RepositoryPolicy toAetherRepoPolicy(io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy modelPolicy) {
        return new RepositoryPolicy(modelPolicy.isEnabled(), StringUtils.isEmpty(modelPolicy.getUpdatePolicy()) ? "io.quarkus.launcher.shaded.daily" : modelPolicy.getUpdatePolicy(), StringUtils.isEmpty(modelPolicy.getChecksumPolicy()) ? "io.quarkus.launcher.shaded.warn" : modelPolicy.getChecksumPolicy());
    }

    private static io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy toAetherProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Authentication auth = null;
        if (proxy.getUsername() != null) {
            auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return new io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
    }

    private RepositorySystem newRepositorySystem() throws AppModelResolverException {
        DefaultServiceLocator locator = this.getServiceLocator();
        if (!this.isOffline()) {
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
            locator.setServices(WagonConfigurator.class, new BootstrapWagonConfigurator());
            locator.setServices(WagonProvider.class, new BootstrapWagonProvider());
        }
        locator.setServices(ModelBuilder.class, new MavenModelBuilder(this.workspace, this.getCliOptions(), this.workspace == null ? Collections.emptyList() : this.getActiveSettingsProfiles()));
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            @Override
            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error((Object)("io.quarkus.launcher.shaded.Failed to initialize " + impl.getName() + "io.quarkus.launcher.shaded. as a service implementing " + type.getName()), exception);
            }
        });
        return locator.getService(RepositorySystem.class);
    }

    public RemoteRepositoryManager getRemoteRepositoryManager() {
        DefaultRemoteRepositoryManager remoteRepoManager = new DefaultRemoteRepositoryManager();
        remoteRepoManager.initService(this.getServiceLocator());
        return remoteRepoManager;
    }

    private DefaultServiceLocator getServiceLocator() {
        return this.serviceLocator == null ? (this.serviceLocator = MavenRepositorySystemUtils.newServiceLocator()) : this.serviceLocator;
    }

    private static String getUserAgent() {
        return "io/quarkus/launcher/shaded/Apache-Maven/" + BootstrapMavenContext.getMavenVersion() + "io.quarkus.launcher.shaded. (Java " + PropertyUtils.getProperty("io/quarkus/launcher/shaded/java.version") + "io.quarkus.launcher.shaded.; " + PropertyUtils.getProperty("io.quarkus.launcher.shaded.os.name") + "io.quarkus.launcher.shaded. " + PropertyUtils.getProperty("io.quarkus.launcher.shaded.os.version") + "io.quarkus.launcher.shaded.)";
    }

    private static String getMavenVersion() {
        String mvnVersion = PropertyUtils.getProperty("io.quarkus.launcher.shaded.maven.version");
        if (mvnVersion != null) {
            return mvnVersion;
        }
        Properties props = new Properties();
        try (InputStream is = BootstrapMavenContext.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            log.debug((Object)"io.quarkus.launcher.shaded.Failed to read Maven version", e);
        }
        return props.getProperty("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.unknown-version");
    }

    public boolean isCurrentProjectExists() {
        return this.currentProjectExists == null ? (this.currentProjectExists = Boolean.valueOf(this.getCurrentProjectPomOrNull() != null)) : this.currentProjectExists;
    }

    public Path getCurrentProjectPomOrNull() {
        if (this.currentPom != null || this.currentProjectExists != null && !this.currentProjectExists.booleanValue()) {
            return this.currentPom;
        }
        Path pom = this.resolveCurrentPom();
        this.currentProjectExists = pom != null;
        this.currentPom = this.currentProjectExists != false ? pom : null;
        return this.currentPom;
    }

    private Path resolveCurrentPom() {
        String basedirProp;
        String cliPomName;
        Path alternatePom = null;
        if (this.alternatePomName != null && (alternatePom = Paths.get(this.alternatePomName, new String[0])).isAbsolute()) {
            return BootstrapMavenContext.pomXmlOrNull(alternatePom);
        }
        if (alternatePom == null && (cliPomName = this.getCliOptions().getOptionValue("io.quarkus.launcher.shaded.f")) != null) {
            alternatePom = Paths.get(cliPomName, new String[0]);
        }
        if ((basedirProp = PropertyUtils.getProperty(BASEDIR)) != null) {
            Path basedir = Paths.get(basedirProp, new String[0]);
            if (alternatePom != null && alternatePom.isAbsolute() && alternatePom.getParent().equals(basedir)) {
                return alternatePom;
            }
            Path pom = basedir.resolve("io.quarkus.launcher.shaded.pom.xml");
            if (Files.exists(pom, new LinkOption[0])) {
                return pom;
            }
            if (alternatePom != null && !alternatePom.isAbsolute() && alternatePom.getNameCount() == 1 && Files.exists(pom = basedir.resolve(alternatePom), new LinkOption[0])) {
                return pom;
            }
            return null;
        }
        if (alternatePom != null && alternatePom.isAbsolute()) {
            return BootstrapMavenContext.pomXmlOrNull(alternatePom);
        }
        Path basedir = Paths.get("io.quarkus.launcher.shaded.", new String[0]).normalize().toAbsolutePath();
        if (alternatePom != null) {
            return BootstrapMavenContext.pomXmlOrNull(basedir.resolve(alternatePom));
        }
        Path pom = basedir.resolve("io.quarkus.launcher.shaded.pom.xml");
        return Files.exists(pom, new LinkOption[0]) ? pom : null;
    }

    private static Path pomXmlOrNull(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            path = path.resolve("io.quarkus.launcher.shaded.pom.xml");
        }
        return Files.exists(path, new LinkOption[0]) ? path : null;
    }

    public Path getCurrentProjectBaseDir() {
        if (this.currentProject != null) {
            return this.currentProject.getDir();
        }
        String basedirProp = PropertyUtils.getProperty(BASEDIR);
        return basedirProp == null ? Paths.get("io.quarkus.launcher.shaded.", new String[0]).normalize().toAbsolutePath() : Paths.get(basedirProp, new String[0]);
    }

    public Path getRootProjectBaseDir() {
        Path currentPom;
        String rootBaseDir = System.getenv(MAVEN_PROJECTBASEDIR);
        if (rootBaseDir == null) {
            return null;
        }
        if (!(this.alternatePomName == null || (currentPom = this.getCurrentProjectPomOrNull()) != null && this.getCurrentProjectBaseDir().equals(currentPom.getParent()))) {
            return null;
        }
        Path rootProjectBaseDirPath = Paths.get(rootBaseDir, new String[0]);
        if (!Files.exists(rootProjectBaseDirPath.resolve("io.quarkus.launcher.shaded.pom.xml"), new LinkOption[0])) {
            return null;
        }
        return rootProjectBaseDirPath;
    }
}

