/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.org.apache.maven.wagon.Wagon;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonProvider;

public class BootstrapWagonProvider
implements WagonProvider {
    @Override
    public Wagon lookup(String roleHint) throws Exception {
        Object wagon;
        String impl = null;
        switch (roleHint) {
            case "io.quarkus.launcher.shaded.https": 
            case "io.quarkus.launcher.shaded.http": {
                impl = "io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.http.HttpWagon";
                break;
            }
            case "io.quarkus.launcher.shaded.file": {
                impl = "io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.file.FileWagon";
                break;
            }
            case "io.quarkus.launcher.shaded.ftp": {
                impl = "io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.ftp.FtpWagon";
                break;
            }
            case "io.quarkus.launcher.shaded.ftps": {
                impl = "io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.ftp.FtpsWagon";
                break;
            }
            case "io.quarkus.launcher.shaded.ftph": {
                impl = "io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.ftp.FtpHttpWagon";
                break;
            }
            case "io.quarkus.launcher.shaded.scm": {
                impl = "io.quarkus.launcher.shaded.org.apache.maven.wagon.providers.scm.ScmWagon";
                break;
            }
            default: {
                throw new IllegalStateException("io.quarkus.launcher.shaded.Not supported Wagon implementation hint " + roleHint);
            }
        }
        Class<?> cls = BootstrapWagonProvider.loadClass(impl, roleHint);
        try {
            wagon = cls.newInstance();
        }
        catch (Throwable t) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to instantiate Wagon impl " + impl, t);
        }
        return (Wagon)Wagon.class.cast(wagon);
    }

    @Override
    public void release(Wagon wagon) {
    }

    private static Class<?> loadClass(String name, String protocol) {
        try {
            return BootstrapWagonProvider.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            StringBuilder buf = new StringBuilder();
            buf.append("io.quarkus.launcher.shaded.Failed to locate Wagon implementation ").append(name).append("io.quarkus.launcher.shaded. on the classpath for protocol ").append(protocol).append("io.quarkus.launcher.shaded., please add the ");
            String defaultWagonGA = BootstrapWagonProvider.getDefaultWagonGA(protocol);
            if (defaultWagonGA == null) {
                buf.append("io.quarkus.launcher.shaded.corresponding classpath dependency to your project");
            } else {
                buf.append("io.quarkus.launcher.shaded.desired version of ").append(defaultWagonGA).append("io.quarkus.launcher.shaded. as a classpath dependency to your project");
            }
            throw new IllegalStateException(buf.toString());
        }
    }

    private static String getDefaultWagonGA(String protocol) {
        switch (protocol) {
            case "io.quarkus.launcher.shaded.https": 
            case "io.quarkus.launcher.shaded.http": {
                return "io.quarkus.launcher.shaded.org.apache.maven.wagon:wagon-http or org.apache.maven.wagon:wagon-http-lightweight";
            }
            case "io.quarkus.launcher.shaded.file": {
                return "io.quarkus.launcher.shaded.org.apache.maven.wagon:wagon-file";
            }
            case "io.quarkus.launcher.shaded.ftp": 
            case "io.quarkus.launcher.shaded.ftps": 
            case "io.quarkus.launcher.shaded.ftph": {
                return "io.quarkus.launcher.shaded.org.apache.maven.wagon:wagon-ftp";
            }
            case "io.quarkus.launcher.shaded.scm": {
                return "io.quarkus.launcher.shaded.org.apache.maven.wagon:wagon-scm";
            }
        }
        return null;
    }
}

