/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.DeploymentInjectingDependencyVisitor;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.Dependency;
import io.quarkus.launcher.shaded.org.eclipse.aether.graph.DependencyNode;
import io.quarkus.launcher.shaded.org.eclipse.aether.resolution.ArtifactRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

public class BuildDependencyGraphVisitor {
    private final Set<AppArtifactKey> appDeps;
    private final StringBuilder buf;
    private final Consumer<String> buildTreeConsumer;
    private final List<Boolean> depth;
    private DependencyNode deploymentNode;
    private DependencyNode runtimeNode;
    private Artifact runtimeArtifact;
    private final List<DependencyNode> deploymentDepNodes = new ArrayList<DependencyNode>();
    private final List<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();

    public BuildDependencyGraphVisitor(Set<AppArtifactKey> appDeps, Consumer<String> buildTreeConsumer) {
        this.appDeps = appDeps;
        this.buildTreeConsumer = buildTreeConsumer;
        if (buildTreeConsumer == null) {
            this.buf = null;
            this.depth = null;
        } else {
            this.buf = new StringBuilder();
            this.depth = new ArrayList<Boolean>();
        }
    }

    public List<DependencyNode> getDeploymentNodes() {
        return this.deploymentDepNodes;
    }

    public List<ArtifactRequest> getArtifactRequests() {
        return this.requests;
    }

    public void visit(DependencyNode node) {
        if (this.depth != null) {
            this.buf.setLength(0);
            if (!this.depth.isEmpty()) {
                for (int i = 0; i < this.depth.size() - 1; ++i) {
                    if (this.depth.get(i).booleanValue()) {
                        this.buf.append('\u2502').append("io.quarkus.launcher.shaded.  ");
                        continue;
                    }
                    this.buf.append("io.quarkus.launcher.shaded.   ");
                }
                if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                    this.buf.append('\u251c').append('\u2500').append(' ');
                } else {
                    this.buf.append('\u2514').append('\u2500').append(' ');
                }
            }
            this.buf.append(node.getArtifact());
            if (!this.depth.isEmpty()) {
                this.buf.append("io.quarkus.launcher.shaded. (").append(node.getDependency().getScope());
                if (node.getDependency().isOptional()) {
                    this.buf.append("io.quarkus.launcher.shaded. optional");
                }
                this.buf.append(')');
            }
            this.buildTreeConsumer.accept(this.buf.toString());
        }
        this.visitEnter(node);
        List<DependencyNode> children = node.getChildren();
        if (!children.isEmpty()) {
            int childrenTotal = children.size();
            if (childrenTotal == 1) {
                if (this.depth != null) {
                    this.depth.add(false);
                }
                this.visit(children.get(0));
            } else {
                if (this.depth != null) {
                    this.depth.add(true);
                }
                int i = 0;
                while (true) {
                    this.visit(children.get(i++));
                    if (i < childrenTotal - 1) continue;
                    if (i == childrenTotal) break;
                    if (this.depth == null) continue;
                    this.depth.set(this.depth.size() - 1, false);
                }
            }
            if (this.depth != null) {
                this.depth.remove(this.depth.size() - 1);
            }
        }
        this.visitLeave(node);
    }

    private void visitEnter(DependencyNode node) {
        Dependency dep = node.getDependency();
        if (this.deploymentNode == null) {
            this.runtimeArtifact = DeploymentInjectingDependencyVisitor.getRuntimeArtifact(node);
            if (this.runtimeArtifact != null) {
                this.deploymentNode = node;
            }
        } else if (this.runtimeArtifact != null && this.runtimeNode == null && this.runtimeArtifact.equals(dep.getArtifact())) {
            this.runtimeNode = node;
        }
    }

    private void visitLeave(DependencyNode node) {
        Dependency dep = node.getDependency();
        if (dep == null) {
            return;
        }
        Artifact artifact = dep.getArtifact();
        if (artifact.getFile() == null) {
            this.requests.add(new ArtifactRequest(node));
        }
        if (this.deploymentNode != null) {
            if (this.runtimeNode == null && !this.appDeps.contains(new AppArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension()))) {
                if (!node.getDependency().isOptional()) {
                    this.deploymentDepNodes.add(node);
                }
            } else if (this.runtimeNode == node) {
                this.runtimeNode = null;
                this.runtimeArtifact = null;
            }
            if (this.deploymentNode == node) {
                this.deploymentNode = null;
            }
        }
    }
}

