/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.artifact.Artifact;
import io.quarkus.launcher.shaded.org.eclipse.aether.metadata.Metadata;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalArtifactRegistration;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalArtifactRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalArtifactResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalMetadataRegistration;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalMetadataRequest;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalMetadataResult;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepositoryManager;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class MavenLocalRepositoryManager
implements LocalRepositoryManager {
    private final LocalRepositoryManager delegate;
    private final Path userLocalRepo;
    private final Path appCreatorRepo;
    private final boolean relinkResolvedArtifacts;

    public MavenLocalRepositoryManager(LocalRepositoryManager delegate, Path userLocalRepo) {
        this(delegate, userLocalRepo, false);
    }

    public MavenLocalRepositoryManager(LocalRepositoryManager delegate, Path userLocalRepo, boolean relinkResolvedArtifacts) {
        this.delegate = delegate;
        this.userLocalRepo = userLocalRepo;
        this.appCreatorRepo = delegate.getRepository().getBasedir().toPath();
        this.relinkResolvedArtifacts = relinkResolvedArtifacts;
    }

    @Override
    public LocalRepository getRepository() {
        return this.delegate.getRepository();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.delegate.getPathForLocalArtifact(artifact);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteArtifact(artifact, repository, context);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.delegate.getPathForLocalMetadata(metadata);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.delegate.getPathForRemoteMetadata(metadata, repository, context);
    }

    public void relink(String groupId, String artifactId, String classifier, String type, String version, Path p) {
        Path creatorRepoPath = this.getLocalPath(this.appCreatorRepo, groupId, artifactId, classifier, type, version);
        try {
            IoUtils.copy(p, creatorRepoPath);
        }
        catch (IOException e) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to copy " + p + "io.quarkus.launcher.shaded. to a staging repo", e);
        }
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        LocalArtifactResult result = this.delegate.find(session, request);
        if (result.isAvailable()) {
            return result;
        }
        Artifact artifact = request.getArtifact();
        Path userRepoPath = this.getLocalPath(this.userLocalRepo, artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
        if (!Files.exists(userRepoPath, new LinkOption[0])) {
            return result;
        }
        if (this.relinkResolvedArtifacts) {
            Path creatorRepoPath = this.getLocalPath(this.appCreatorRepo, artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getExtension(), artifact.getVersion());
            try {
                IoUtils.copy(userRepoPath, creatorRepoPath);
            }
            catch (IOException e) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to copy " + userRepoPath + "io.quarkus.launcher.shaded. to a staging repo", e);
            }
            result.setFile(creatorRepoPath.toFile());
        } else {
            result.setFile(userRepoPath.toFile());
        }
        artifact.setFile(result.getFile());
        result.setAvailable(true);
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        this.delegate.add(session, request);
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = this.delegate.find(session, request);
        if (result.getFile() != null && result.getFile().exists()) {
            return result;
        }
        Metadata metadata = request.getMetadata();
        Path userRepoPath = this.getMetadataPath(this.userLocalRepo, metadata.getGroupId(), metadata.getArtifactId(), metadata.getType(), metadata.getVersion());
        if (!Files.exists(userRepoPath, new LinkOption[0])) {
            return result;
        }
        if (this.relinkResolvedArtifacts) {
            Path creatorRepoPath = this.getMetadataPath(this.appCreatorRepo, metadata.getGroupId(), metadata.getArtifactId(), metadata.getType(), metadata.getVersion());
            try {
                IoUtils.copy(userRepoPath, creatorRepoPath);
            }
            catch (IOException e) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to copy " + userRepoPath + "io.quarkus.launcher.shaded. to a staging repo", e);
            }
            result.setFile(creatorRepoPath.toFile());
        } else {
            result.setFile(userRepoPath.toFile());
        }
        metadata.setFile(result.getFile());
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        this.delegate.add(session, request);
    }

    private Path getMetadataPath(Path repoHome, String groupId, String artifactId, String type, String version) {
        String[] groupParts;
        Path p = repoHome;
        for (String part : groupParts = groupId.split("io.quarkus.launcher.shaded.\\.")) {
            p = p.resolve(part);
        }
        if (artifactId != null) {
            p = p.resolve(artifactId);
        }
        if (version != null) {
            p = p.resolve(version);
        }
        return p.resolve("io.quarkus.launcher.shaded.maven-metadata-local.xml");
    }

    private Path getLocalPath(Path repoHome, String groupId, String artifactId, String classifier, String type, String version) {
        String[] groupParts;
        Path p = repoHome;
        for (String part : groupParts = groupId.split("io.quarkus.launcher.shaded.\\.")) {
            p = p.resolve(part);
        }
        StringBuilder fileName = new StringBuilder();
        fileName.append(artifactId).append('-').append(version);
        if (classifier != null && !classifier.isEmpty()) {
            fileName.append('-').append(classifier);
        }
        fileName.append('.').append(type);
        return p.resolve(artifactId).resolve(version).resolve(fileName.toString());
    }
}

