/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.BootstrapWagonProvider;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.MavenModelBuilder;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.SettingsDecrypterImpl;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.util.PropertyUtils;
import io.quarkus.launcher.shaded.org.apache.maven.model.Profile;
import io.quarkus.launcher.shaded.org.apache.maven.model.Repository;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelBuilder;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollector;
import io.quarkus.launcher.shaded.org.apache.maven.model.building.ModelProblemCollectorRequest;
import io.quarkus.launcher.shaded.org.apache.maven.model.path.DefaultPathTranslator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.DefaultProfileActivationContext;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.DefaultProfileSelector;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.FileProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.profile.activation.PropertyProfileActivator;
import io.quarkus.launcher.shaded.org.apache.maven.model.resolution.WorkspaceModelResolver;
import io.quarkus.launcher.shaded.org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Mirror;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Settings;
import io.quarkus.launcher.shaded.org.apache.maven.settings.SettingsUtils;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingException;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsBuildingResult;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import io.quarkus.launcher.shaded.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import io.quarkus.launcher.shaded.org.codehaus.plexus.util.xml.Xpp3Dom;
import io.quarkus.launcher.shaded.org.eclipse.aether.DefaultRepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystem;
import io.quarkus.launcher.shaded.org.eclipse.aether.RepositorySystemSession;
import io.quarkus.launcher.shaded.org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.impl.DefaultServiceLocator;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.ArtifactRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.Authentication;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.LocalRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RemoteRepository;
import io.quarkus.launcher.shaded.org.eclipse.aether.repository.RepositoryPolicy;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.spi.connector.transport.TransporterFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonProvider;
import io.quarkus.launcher.shaded.org.eclipse.aether.transport.wagon.WagonTransporterFactory;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.AuthenticationBuilder;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultMirrorSelector;
import io.quarkus.launcher.shaded.org.eclipse.aether.util.repository.DefaultProxySelector;
import io.quarkus.launcher.shaded.org.jboss.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;

@Deprecated
public class MavenRepoInitializer {
    private static final String DEFAULT_REMOTE_REPO_ID = "io.quarkus.launcher.shaded.central";
    private static final String DEFAULT_REMOTE_REPO_URL = "io/quarkus/launcher/shaded/https://repo.maven.apache.org/maven2";
    private static final String BASEDIR = "io.quarkus.launcher.shaded.basedir";
    private static final String DOT_M2 = "io.quarkus.launcher.shaded..m2";
    private static final String MAVEN_DOT_HOME = "io.quarkus.launcher.shaded.maven.home";
    private static final String MAVEN_HOME = "io.quarkus.launcher.shaded.MAVEN_HOME";
    private static final String SETTINGS_XML = "io.quarkus.launcher.shaded.settings.xml";
    private static final String userHome = PropertyUtils.getUserHome();
    private static final File userMavenConfigurationHome = new File(userHome, "io.quarkus.launcher.shaded..m2");
    private static final String envM2Home = System.getenv("io.quarkus.launcher.shaded.MAVEN_HOME");
    private static final File USER_SETTINGS_FILE;
    private static final File GLOBAL_SETTINGS_FILE;
    private static final String ALTERNATE_USER_SETTINGS = "io.quarkus.launcher.shaded.s";
    private static final String ALTERNATE_GLOBAL_SETTINGS = "io.quarkus.launcher.shaded.gs";
    private static final String ALTERNATE_POM_FILE = "io.quarkus.launcher.shaded.f";
    private static final String OFFLINE = "io.quarkus.launcher.shaded.o";
    private static final String SUPRESS_SNAPSHOT_UPDATES = "io.quarkus.launcher.shaded.nsu";
    private static final String UPDATE_SNAPSHOTS = "io.quarkus.launcher.shaded.U";
    private static final String CHECKSUM_FAILURE_POLICY = "io.quarkus.launcher.shaded.C";
    private static final String CHECKSUM_WARNING_POLICY = "io.quarkus.launcher.shaded.c";
    private static final BootstrapMavenOptions mvnArgs;
    private static Settings settings;
    private static final Logger log;

    private static File resolveUserSettings(String settingsArg) {
        File userSettings = new File(settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        String base = System.getenv("io.quarkus.launcher.shaded.MAVEN_PROJECTBASEDIR");
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        base = PropertyUtils.getProperty(BASEDIR);
        if (base != null && (userSettings = new File(base, settingsArg)).exists()) {
            return userSettings;
        }
        userSettings = new File(userHome, settingsArg);
        if (userSettings.exists()) {
            return userSettings;
        }
        return null;
    }

    public static RepositorySystem getRepositorySystem() {
        return MavenRepoInitializer.getRepositorySystem(false, null);
    }

    public static BootstrapMavenOptions getBootstrapMavenOptions() {
        return mvnArgs;
    }

    public static RepositorySystem getRepositorySystem(boolean offline, WorkspaceModelResolver wsModelResolver) {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        if (!offline) {
            locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
            locator.addService(TransporterFactory.class, WagonTransporterFactory.class);
            locator.setServices(WagonProvider.class, new BootstrapWagonProvider());
        }
        try {
            locator.setServices(ModelBuilder.class, new MavenModelBuilder(wsModelResolver, mvnArgs, wsModelResolver == null ? Collections.emptyList() : MavenRepoInitializer.getActiveSettingsProfiles()));
        }
        catch (AppModelResolverException e) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to resolve active settings profiles", e);
        }
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            @Override
            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                log.error((Object)("io.quarkus.launcher.shaded.Failed to initialize " + impl.getName() + "io.quarkus.launcher.shaded. as a service implementing " + type.getName()), exception);
            }
        });
        return locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system) throws AppModelResolverException {
        return MavenRepoInitializer.newSession(system, MavenRepoInitializer.getSettings());
    }

    public static DefaultRepositorySystemSession newSession(RepositorySystem system, Settings settings) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        List<Mirror> mirrors = settings.getMirrors();
        if (mirrors != null && !mirrors.isEmpty()) {
            DefaultMirrorSelector ms = new DefaultMirrorSelector();
            for (Mirror m : mirrors) {
                ms.add(m.getId(), m.getUrl(), m.getLayout(), false, m.getMirrorOf(), m.getMirrorOfLayouts());
            }
            session.setMirrorSelector(ms);
        }
        String localRepoPath = MavenRepoInitializer.getLocalRepo(settings);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager(session, new LocalRepository(localRepoPath)));
        session.setOffline(settings.isOffline());
        if (!mvnArgs.isEmpty()) {
            if (!session.isOffline() && mvnArgs.hasOption(OFFLINE)) {
                session.setOffline(true);
            }
            if (mvnArgs.hasOption(SUPRESS_SNAPSHOT_UPDATES)) {
                session.setUpdatePolicy("io.quarkus.launcher.shaded.never");
            } else if (mvnArgs.hasOption(UPDATE_SNAPSHOTS)) {
                session.setUpdatePolicy("io.quarkus.launcher.shaded.always");
            }
            if (mvnArgs.hasOption(CHECKSUM_FAILURE_POLICY)) {
                session.setChecksumPolicy("io.quarkus.launcher.shaded.fail");
            } else if (mvnArgs.hasOption(CHECKSUM_WARNING_POLICY)) {
                session.setChecksumPolicy("io.quarkus.launcher.shaded.warn");
            }
        }
        DefaultSettingsDecryptionRequest decrypt = new DefaultSettingsDecryptionRequest();
        decrypt.setProxies((List)settings.getProxies());
        decrypt.setServers((List)settings.getServers());
        SettingsDecryptionResult decrypted = new SettingsDecrypterImpl().decrypt(decrypt);
        if (!decrypted.getProblems().isEmpty() && log.isDebugEnabled()) {
            for (SettingsProblem settingsProblem : decrypted.getProblems()) {
                log.debug((Object)settingsProblem.getMessage(), settingsProblem.getException());
            }
        }
        DefaultProxySelector proxySelector = new DefaultProxySelector();
        for (Proxy p : decrypted.getProxies()) {
            proxySelector.add(MavenRepoInitializer.toAetherProxy(p), p.getNonProxyHosts());
        }
        session.setProxySelector(proxySelector);
        LinkedHashMap<Object, Object> linkedHashMap = new LinkedHashMap<Object, Object>();
        linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.userAgent", MavenRepoInitializer.getUserAgent());
        linkedHashMap.put("io.quarkus.launcher.shaded.aether.interactive", settings.isInteractiveMode());
        linkedHashMap.putAll(System.getProperties());
        DefaultAuthenticationSelector authSelector = new DefaultAuthenticationSelector();
        for (Server server : decrypted.getServers()) {
            AuthenticationBuilder authBuilder = new AuthenticationBuilder();
            authBuilder.addUsername(server.getUsername()).addPassword(server.getPassword());
            authBuilder.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            authSelector.add(server.getId(), authBuilder.build());
            if (server.getConfiguration() != null) {
                Xpp3Dom dom = (Xpp3Dom)server.getConfiguration();
                for (int i = dom.getChildCount() - 1; i >= 0; --i) {
                    Xpp3Dom child = dom.getChild(i);
                    if (!"io.quarkus.launcher.shaded.wagonProvider".equals(child.getName())) continue;
                    dom.removeChild(i);
                }
                XmlPlexusConfiguration config = new XmlPlexusConfiguration(dom);
                linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.wagon.config." + server.getId(), config);
            }
            linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.perms.fileMode." + server.getId(), server.getFilePermissions());
            linkedHashMap.put("io.quarkus.launcher.shaded.aether.connector.perms.dirMode." + server.getId(), server.getDirectoryPermissions());
        }
        session.setAuthenticationSelector(authSelector);
        session.setConfigProperties(linkedHashMap);
        return session;
    }

    public static List<RemoteRepository> getRemoteRepos(RepositorySystem repoSystem, RepositorySystemSession repoSession) throws AppModelResolverException {
        return Collections.unmodifiableList(MavenRepoInitializer.getRemoteRepos(MavenRepoInitializer.getSettings(), repoSystem, repoSession));
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings) throws AppModelResolverException {
        RepositorySystem system = MavenRepoInitializer.getRepositorySystem();
        return MavenRepoInitializer.getRemoteRepos(settings, system, MavenRepoInitializer.newSession(system, settings));
    }

    public static List<RemoteRepository> getRemoteRepos(Settings settings, RepositorySystem repoSystem, RepositorySystemSession repoSession) throws AppModelResolverException {
        ArrayList<RemoteRepository> remotes = new ArrayList<RemoteRepository>();
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal > 0) {
            for (Profile modelProfile : MavenRepoInitializer.getActiveSettingsProfiles(settings)) {
                MavenRepoInitializer.addProfileRepos(modelProfile, remotes);
            }
        }
        if (remotes.isEmpty() || !MavenRepoInitializer.includesDefaultRepo(remotes)) {
            remotes.add(new RemoteRepository.Builder(DEFAULT_REMOTE_REPO_ID, "io.quarkus.launcher.shaded.default", DEFAULT_REMOTE_REPO_URL).setReleasePolicy(new RepositoryPolicy(true, "io.quarkus.launcher.shaded.daily", "io.quarkus.launcher.shaded.warn")).setSnapshotPolicy(new RepositoryPolicy(false, "io.quarkus.launcher.shaded.daily", "io.quarkus.launcher.shaded.warn")).build());
        }
        return repoSystem.newResolutionRepositories(repoSession, remotes);
    }

    public static List<Profile> getActiveSettingsProfiles() throws AppModelResolverException {
        return MavenRepoInitializer.getActiveSettingsProfiles(MavenRepoInitializer.getSettings());
    }

    public static List<Profile> getActiveSettingsProfiles(Settings settings) throws AppModelResolverException {
        int profilesTotal = settings.getProfiles().size();
        if (profilesTotal == 0) {
            return Collections.emptyList();
        }
        List<Profile> modelProfiles = new ArrayList<Profile>(profilesTotal);
        for (io.quarkus.launcher.shaded.org.apache.maven.settings.Profile profile : settings.getProfiles()) {
            modelProfiles.add(SettingsUtils.convertFromSettingsProfile(profile));
        }
        List<String> activeProfiles = mvnArgs.getActiveProfileIds();
        List<String> inactiveProfiles = mvnArgs.getInactiveProfileIds();
        Path currentPom = MavenRepoInitializer.getCurrentProjectPomOrNull();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext().setActiveProfileIds(activeProfiles).setInactiveProfileIds(inactiveProfiles).setSystemProperties(System.getProperties()).setProjectDirectory(currentPom == null ? MavenRepoInitializer.getCurrentDir().toFile() : currentPom.getParent().toFile());
        DefaultProfileSelector profileSelector = new DefaultProfileSelector().addProfileActivator(new PropertyProfileActivator()).addProfileActivator(new JdkVersionProfileActivator()).addProfileActivator(new OperatingSystemProfileActivator()).addProfileActivator(new FileProfileActivator().setPathTranslator(new DefaultPathTranslator()));
        modelProfiles = profileSelector.getActiveProfiles(modelProfiles, context, new ModelProblemCollector(){

            @Override
            public void add(ModelProblemCollectorRequest req) {
                log.error("io.quarkus.launcher.shaded.Failed to activate a Maven profile: " + req.getMessage());
            }
        });
        activeProfiles = settings.getActiveProfiles();
        if (!activeProfiles.isEmpty()) {
            for (String profileName : activeProfiles) {
                io.quarkus.launcher.shaded.org.apache.maven.settings.Profile profile = MavenRepoInitializer.getProfile(profileName, settings);
                if (profile == null) continue;
                modelProfiles.add(SettingsUtils.convertFromSettingsProfile(profile));
            }
        }
        return modelProfiles;
    }

    static Path getCurrentProjectPomOrNull() {
        Path pom;
        String pomName = mvnArgs.getOptionValue(ALTERNATE_POM_FILE);
        if (pomName == null) {
            pomName = "io.quarkus.launcher.shaded.pom.xml";
        }
        if (!(pom = Paths.get(pomName, new String[0])).isAbsolute()) {
            pom = MavenRepoInitializer.getCurrentDir().resolve(pom);
        }
        if (Files.isDirectory(pom, new LinkOption[0])) {
            pom = pom.resolve("io.quarkus.launcher.shaded.pom.xml");
        }
        return Files.exists(pom, new LinkOption[0]) ? pom : null;
    }

    private static Path getCurrentDir() {
        String basedirProp = PropertyUtils.getProperty(BASEDIR);
        return basedirProp == null ? Paths.get("io.quarkus.launcher.shaded.", new String[0]).normalize().toAbsolutePath() : Paths.get(basedirProp, new String[0]);
    }

    private static io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy toAetherProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        Authentication auth = null;
        if (proxy.getUsername() != null) {
            auth = new AuthenticationBuilder().addUsername(proxy.getUsername()).addPassword(proxy.getPassword()).build();
        }
        return new io.quarkus.launcher.shaded.org.eclipse.aether.repository.Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
    }

    private static io.quarkus.launcher.shaded.org.apache.maven.settings.Profile getProfile(String name, Settings settings) throws AppModelResolverException {
        io.quarkus.launcher.shaded.org.apache.maven.settings.Profile profile = settings.getProfilesAsMap().get(name);
        if (profile == null) {
            MavenRepoInitializer.unrecognizedProfile(name, true);
        }
        return profile;
    }

    private static void unrecognizedProfile(String name, boolean activate) {
        StringBuilder buf = new StringBuilder();
        buf.append("io.quarkus.launcher.shaded.The requested Maven profile \"").append(name).append("io.quarkus.launcher.shaded.\" could not be ");
        if (!activate) {
            buf.append("io.quarkus.launcher.shaded.de");
        }
        buf.append("io.quarkus.launcher.shaded.activated because it does not exist.");
        log.warn(buf.toString());
    }

    private static void addProfileRepos(Profile profile, List<RemoteRepository> all) {
        List<Repository> repositories = profile.getRepositories();
        for (Repository repo : repositories) {
            RemoteRepository.Builder repoBuilder = new RemoteRepository.Builder(repo.getId(), repo.getLayout(), repo.getUrl());
            io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy policy = repo.getReleases();
            if (policy != null) {
                repoBuilder.setReleasePolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            if ((policy = repo.getSnapshots()) != null) {
                repoBuilder.setSnapshotPolicy(MavenRepoInitializer.toAetherRepoPolicy(policy));
            }
            all.add(repoBuilder.build());
        }
    }

    public static Settings getSettings() throws AppModelResolverException {
        Settings effectiveSettings;
        if (settings != null) {
            return settings;
        }
        try {
            SettingsBuildingResult result = new DefaultSettingsBuilderFactory().newInstance().build(new DefaultSettingsBuildingRequest().setSystemProperties(System.getProperties()).setUserSettingsFile(USER_SETTINGS_FILE).setGlobalSettingsFile(GLOBAL_SETTINGS_FILE));
            List<SettingsProblem> problems = result.getProblems();
            if (!problems.isEmpty()) {
                for (SettingsProblem problem : problems) {
                    switch (problem.getSeverity()) {
                        case ERROR: 
                        case FATAL: {
                            throw new AppModelResolverException("io.quarkus.launcher.shaded.Settings problem encountered at " + problem.getLocation(), problem.getException());
                        }
                    }
                    log.warn((Object)("io.quarkus.launcher.shaded.Settings problem encountered at " + problem.getLocation()), problem.getException());
                }
            }
            effectiveSettings = result.getEffectiveSettings();
        }
        catch (SettingsBuildingException e) {
            throw new AppModelResolverException("io.quarkus.launcher.shaded.Failed to initialize Maven repository settings", e);
        }
        settings = effectiveSettings;
        return settings;
    }

    public static String getLocalRepo(Settings settings) {
        String localRepo = System.getenv("io.quarkus.launcher.shaded.QUARKUS_LOCAL_REPO");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = PropertyUtils.getProperty("io.quarkus.launcher.shaded.maven.repo.local");
        if (localRepo != null) {
            return localRepo;
        }
        localRepo = settings.getLocalRepository();
        return localRepo == null ? MavenRepoInitializer.getDefaultLocalRepo() : localRepo;
    }

    private static String getDefaultLocalRepo() {
        return new File(userMavenConfigurationHome, "io.quarkus.launcher.shaded.repository").getAbsolutePath();
    }

    private static boolean includesDefaultRepo(List<RemoteRepository> repositories) {
        for (ArtifactRepository artifactRepository : repositories) {
            if (!artifactRepository.getId().equals(DEFAULT_REMOTE_REPO_ID)) continue;
            return true;
        }
        return false;
    }

    private static RepositoryPolicy toAetherRepoPolicy(io.quarkus.launcher.shaded.org.apache.maven.model.RepositoryPolicy modelPolicy) {
        return new RepositoryPolicy(modelPolicy.isEnabled(), MavenRepoInitializer.isEmpty(modelPolicy.getUpdatePolicy()) ? "io.quarkus.launcher.shaded.daily" : modelPolicy.getUpdatePolicy(), MavenRepoInitializer.isEmpty(modelPolicy.getChecksumPolicy()) ? "io.quarkus.launcher.shaded.warn" : modelPolicy.getChecksumPolicy());
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    private static String getUserAgent() {
        return "io/quarkus/launcher/shaded/Apache-Maven/" + MavenRepoInitializer.getMavenVersion() + "io.quarkus.launcher.shaded. (Java " + PropertyUtils.getProperty("io/quarkus/launcher/shaded/java.version") + "io.quarkus.launcher.shaded.; " + PropertyUtils.getProperty("io.quarkus.launcher.shaded.os.name") + "io.quarkus.launcher.shaded. " + PropertyUtils.getProperty("io.quarkus.launcher.shaded.os.version") + "io.quarkus.launcher.shaded.)";
    }

    private static String getMavenVersion() {
        Properties props = new Properties();
        try (InputStream is = MavenRepoInitializer.class.getResourceAsStream("/META-INF/maven/org.apache.maven/maven-core/pom.properties");){
            if (is != null) {
                props.load(is);
            }
        }
        catch (IOException e) {
            log.debug((Object)"io.quarkus.launcher.shaded.Failed to read Maven version", e);
        }
        return props.getProperty("io.quarkus.launcher.shaded.version", "io.quarkus.launcher.shaded.unknown-version");
    }

    static {
        mvnArgs = BootstrapMavenOptions.newInstance();
        String userSettings = mvnArgs.getOptionValue(ALTERNATE_USER_SETTINGS);
        String globalSettings = mvnArgs.getOptionValue(ALTERNATE_GLOBAL_SETTINGS);
        File f = userSettings != null ? MavenRepoInitializer.resolveUserSettings(userSettings) : new File(userMavenConfigurationHome, SETTINGS_XML);
        File file = USER_SETTINGS_FILE = f != null && f.exists() ? f : null;
        f = globalSettings != null ? MavenRepoInitializer.resolveUserSettings(globalSettings) : new File(PropertyUtils.getProperty(MAVEN_DOT_HOME, envM2Home != null ? envM2Home : "io.quarkus.launcher.shaded."), "io/quarkus/launcher/shaded/conf/settings.xml");
        GLOBAL_SETTINGS_FILE = f != null && f.exists() ? f : null;
        log = Logger.getLogger(MavenRepoInitializer.class);
    }
}

