/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher.PlexusCipher;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.cipher.PlexusCipherException;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.PasswordDecryptor;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class SecDispatcherImpl
implements SecDispatcher {
    public static final String SYSTEM_PROPERTY_SEC_LOCATION = "io.quarkus.launcher.shaded.settings.security";
    public static final String TYPE_ATTR = "io.quarkus.launcher.shaded.type";
    public static final char ATTR_START = '[';
    public static final char ATTR_STOP = ']';
    protected PlexusCipher _cipher;
    protected Map _decryptors;
    protected String _configurationFile = "io/quarkus/launcher/shaded/~/.m2/settings-security.xml";

    public SecDispatcherImpl() {
        try {
            this._cipher = new DefaultPlexusCipher();
        }
        catch (PlexusCipherException e) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Failed to init Security Dispatcher", e);
        }
    }

    @Override
    public String decrypt(String str) throws SecDispatcherException {
        if (!this.isEncryptedString(str)) {
            return str;
        }
        String bare = null;
        try {
            bare = this._cipher.unDecorate(str);
        }
        catch (PlexusCipherException e1) {
            throw new SecDispatcherException(e1);
        }
        try {
            Map attr = this.stripAttributes(bare);
            String res = null;
            SettingsSecurity sec = this.getSec();
            if (attr != null && attr.get(TYPE_ATTR) != null) {
                String type = (String)attr.get(TYPE_ATTR);
                if (this._decryptors == null) {
                    throw new SecDispatcherException("io.quarkus.launcher.shaded.plexus container did not supply any required dispatchers - cannot lookup " + type);
                }
                Map conf = SecUtil.getConfig(sec, type);
                PasswordDecryptor dispatcher = (PasswordDecryptor)this._decryptors.get(type);
                if (dispatcher == null) {
                    throw new SecDispatcherException("io.quarkus.launcher.shaded.no dispatcher for hint " + type);
                }
                String pass = this.strip(bare);
                return dispatcher.decrypt(pass, attr, conf);
            }
            String master = this.getMaster(sec);
            res = this._cipher.decrypt(bare, master);
            return res;
        }
        catch (Exception e) {
            throw new SecDispatcherException(e);
        }
    }

    private String strip(String str) {
        int pos = str.indexOf(93);
        if (pos == str.length()) {
            return null;
        }
        if (pos != -1) {
            return str.substring(pos + 1);
        }
        return str;
    }

    private Map stripAttributes(String str) {
        int start = str.indexOf(91);
        int stop = str.indexOf(93);
        if (start != -1 && stop != -1 && stop > start) {
            if (stop == start + 1) {
                return null;
            }
            String attrs = str.substring(start + 1, stop).trim();
            if (attrs == null || attrs.length() < 1) {
                return null;
            }
            HashMap<String, String> res = null;
            StringTokenizer st = new StringTokenizer(attrs, "io.quarkus.launcher.shaded., ");
            while (st.hasMoreTokens()) {
                String pair;
                int pos;
                if (res == null) {
                    res = new HashMap<String, String>(st.countTokens());
                }
                if ((pos = (pair = st.nextToken()).indexOf(61)) == -1) continue;
                String key = pair.substring(0, pos).trim();
                if (pos == pair.length()) {
                    res.put(key, null);
                    continue;
                }
                String val = pair.substring(pos + 1);
                res.put(key, val.trim());
            }
            return res;
        }
        return null;
    }

    private boolean isEncryptedString(String str) {
        if (str == null) {
            return false;
        }
        return this._cipher.isEncryptedString(str);
    }

    private SettingsSecurity getSec() throws SecDispatcherException {
        String location = System.getProperty(SYSTEM_PROPERTY_SEC_LOCATION, this.getConfigurationFile());
        String realLocation = location.charAt(0) == '~' ? System.getProperty("io.quarkus.launcher.shaded.user.home") + location.substring(1) : location;
        SettingsSecurity sec = SecUtil.read(realLocation, true);
        if (sec == null) {
            throw new SecDispatcherException("io.quarkus.launcher.shaded.cannot retrieve master password. Please check that " + realLocation + "io.quarkus.launcher.shaded. exists and has data");
        }
        return sec;
    }

    private String getMaster(SettingsSecurity sec) throws SecDispatcherException {
        String master = sec.getMaster();
        if (master == null) {
            throw new SecDispatcherException("io.quarkus.launcher.shaded.master password is not set");
        }
        try {
            return this._cipher.decryptDecorated(master, SYSTEM_PROPERTY_SEC_LOCATION);
        }
        catch (PlexusCipherException e) {
            throw new SecDispatcherException(e);
        }
    }

    public String getConfigurationFile() {
        return this._configurationFile;
    }

    public void setConfigurationFile(String file) {
        this._configurationFile = file;
    }
}

