/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven;

import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.SecDispatcherImpl;
import io.quarkus.launcher.shaded.io.quarkus.bootstrap.resolver.maven.SettingsDecryptionResultImpl;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Proxy;
import io.quarkus.launcher.shaded.org.apache.maven.settings.Server;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.DefaultSettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.building.SettingsProblem;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecrypter;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import io.quarkus.launcher.shaded.org.apache.maven.settings.crypto.SettingsDecryptionResult;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import io.quarkus.launcher.shaded.org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import java.util.ArrayList;

public class SettingsDecrypterImpl
implements SettingsDecrypter {
    private SecDispatcher securityDispatcher = new SecDispatcherImpl();

    @Override
    public SettingsDecryptionResult decrypt(SettingsDecryptionRequest request) {
        ArrayList<SettingsProblem> problems = new ArrayList<SettingsProblem>();
        ArrayList<Server> servers = new ArrayList<Server>();
        for (Server server : request.getServers()) {
            server = server.clone();
            servers.add(server);
            try {
                server.setPassword(this.decrypt(server.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("io.quarkus.launcher.shaded.Failed to decrypt password for server " + server.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage(), SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.server: " + server.getId(), -1, -1, e));
            }
            try {
                server.setPassphrase(this.decrypt(server.getPassphrase()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("io.quarkus.launcher.shaded.Failed to decrypt passphrase for server " + server.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage(), SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.server: " + server.getId(), -1, -1, e));
            }
        }
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        for (Proxy proxy : request.getProxies()) {
            proxy = proxy.clone();
            proxies.add(proxy);
            try {
                proxy.setPassword(this.decrypt(proxy.getPassword()));
            }
            catch (SecDispatcherException e) {
                problems.add(new DefaultSettingsProblem("io.quarkus.launcher.shaded.Failed to decrypt password for proxy " + proxy.getId() + "io.quarkus.launcher.shaded.: " + e.getMessage(), SettingsProblem.Severity.ERROR, "io.quarkus.launcher.shaded.proxy: " + proxy.getId(), -1, -1, e));
            }
        }
        return new SettingsDecryptionResultImpl(servers, proxies, problems);
    }

    private String decrypt(String str) throws SecDispatcherException {
        return str == null ? null : this.securityDispatcher.decrypt(str);
    }
}

