/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.cli;

import io.quarkus.launcher.shaded.org.apache.commons.cli.UnrecognizedOptionException;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmbiguousOptionException
extends UnrecognizedOptionException {
    private static final long serialVersionUID = 5829816121277947229L;
    private final Collection<String> matchingOptions;

    public AmbiguousOptionException(String option, Collection<String> matchingOptions) {
        super(AmbiguousOptionException.createMessage(option, matchingOptions), option);
        this.matchingOptions = matchingOptions;
    }

    public Collection<String> getMatchingOptions() {
        return this.matchingOptions;
    }

    private static String createMessage(String option, Collection<String> matchingOptions) {
        StringBuilder buf = new StringBuilder("io.quarkus.launcher.shaded.Ambiguous option: '");
        buf.append(option);
        buf.append("io.quarkus.launcher.shaded.'  (could be: ");
        Iterator<String> it = matchingOptions.iterator();
        while (it.hasNext()) {
            buf.append("io.quarkus.launcher.shaded.'");
            buf.append(it.next());
            buf.append("io.quarkus.launcher.shaded.'");
            if (!it.hasNext()) continue;
            buf.append("io.quarkus.launcher.shaded., ");
        }
        buf.append("io.quarkus.launcher.shaded.)");
        return buf.toString();
    }
}

