/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.codec.language;

import io.quarkus.launcher.shaded.org.apache.commons.codec.EncoderException;
import io.quarkus.launcher.shaded.org.apache.commons.codec.StringEncoder;
import io.quarkus.launcher.shaded.org.apache.commons.codec.binary.StringUtils;
import java.util.Locale;

public class DoubleMetaphone
implements StringEncoder {
    private static final String VOWELS = "io.quarkus.launcher.shaded.AEIOUY";
    private static final String[] SILENT_START = new String[]{"io.quarkus.launcher.shaded.GN", "io.quarkus.launcher.shaded.KN", "io.quarkus.launcher.shaded.PN", "io.quarkus.launcher.shaded.WR", "io.quarkus.launcher.shaded.PS"};
    private static final String[] L_R_N_M_B_H_F_V_W_SPACE = new String[]{"io.quarkus.launcher.shaded.L", "io.quarkus.launcher.shaded.R", "io.quarkus.launcher.shaded.N", "io.quarkus.launcher.shaded.M", "io.quarkus.launcher.shaded.B", "io.quarkus.launcher.shaded.H", "io.quarkus.launcher.shaded.F", "io.quarkus.launcher.shaded.V", "io.quarkus.launcher.shaded.W", "io.quarkus.launcher.shaded. "};
    private static final String[] ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER = new String[]{"io.quarkus.launcher.shaded.ES", "io.quarkus.launcher.shaded.EP", "io.quarkus.launcher.shaded.EB", "io.quarkus.launcher.shaded.EL", "io.quarkus.launcher.shaded.EY", "io.quarkus.launcher.shaded.IB", "io.quarkus.launcher.shaded.IL", "io.quarkus.launcher.shaded.IN", "io.quarkus.launcher.shaded.IE", "io.quarkus.launcher.shaded.EI", "io.quarkus.launcher.shaded.ER"};
    private static final String[] L_T_K_S_N_M_B_Z = new String[]{"io.quarkus.launcher.shaded.L", "io.quarkus.launcher.shaded.T", "io.quarkus.launcher.shaded.K", "io.quarkus.launcher.shaded.S", "io.quarkus.launcher.shaded.N", "io.quarkus.launcher.shaded.M", "io.quarkus.launcher.shaded.B", "io.quarkus.launcher.shaded.Z"};
    private int maxCodeLen = 4;

    public String doubleMetaphone(String value) {
        return this.doubleMetaphone(value, false);
    }

    public String doubleMetaphone(String value, boolean alternate) {
        if ((value = this.cleanInput(value)) == null) {
            return null;
        }
        boolean slavoGermanic = this.isSlavoGermanic(value);
        int index = this.isSilentStart(value) ? 1 : 0;
        DoubleMetaphoneResult result = new DoubleMetaphoneResult(this.getMaxCodeLen());
        block25: while (!result.isComplete() && index <= value.length() - 1) {
            switch (value.charAt(index)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    index = this.handleAEIOUY(result, index);
                    continue block25;
                }
                case 'B': {
                    result.append('P');
                    index = this.charAt(value, index + 1) == 'B' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00c7': {
                    result.append('S');
                    ++index;
                    continue block25;
                }
                case 'C': {
                    index = this.handleC(value, result, index);
                    continue block25;
                }
                case 'D': {
                    index = this.handleD(value, result, index);
                    continue block25;
                }
                case 'F': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'F' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'G': {
                    index = this.handleG(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'H': {
                    index = this.handleH(value, result, index);
                    continue block25;
                }
                case 'J': {
                    index = this.handleJ(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'K': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'K' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'L': {
                    index = this.handleL(value, result, index);
                    continue block25;
                }
                case 'M': {
                    result.append('M');
                    index = this.conditionM0(value, index) ? index + 2 : index + 1;
                    continue block25;
                }
                case 'N': {
                    result.append('N');
                    index = this.charAt(value, index + 1) == 'N' ? index + 2 : index + 1;
                    continue block25;
                }
                case '\u00d1': {
                    result.append('N');
                    ++index;
                    continue block25;
                }
                case 'P': {
                    index = this.handleP(value, result, index);
                    continue block25;
                }
                case 'Q': {
                    result.append('K');
                    index = this.charAt(value, index + 1) == 'Q' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'R': {
                    index = this.handleR(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'S': {
                    index = this.handleS(value, result, index, slavoGermanic);
                    continue block25;
                }
                case 'T': {
                    index = this.handleT(value, result, index);
                    continue block25;
                }
                case 'V': {
                    result.append('F');
                    index = this.charAt(value, index + 1) == 'V' ? index + 2 : index + 1;
                    continue block25;
                }
                case 'W': {
                    index = this.handleW(value, result, index);
                    continue block25;
                }
                case 'X': {
                    index = this.handleX(value, result, index);
                    continue block25;
                }
                case 'Z': {
                    index = this.handleZ(value, result, index, slavoGermanic);
                    continue block25;
                }
            }
            ++index;
        }
        return alternate ? result.getAlternate() : result.getPrimary();
    }

    @Override
    public Object encode(Object obj) throws EncoderException {
        if (!(obj instanceof String)) {
            throw new EncoderException("io.quarkus.launcher.shaded.DoubleMetaphone encode parameter is not of type String");
        }
        return this.doubleMetaphone((String)obj);
    }

    @Override
    public String encode(String value) {
        return this.doubleMetaphone(value);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2) {
        return this.isDoubleMetaphoneEqual(value1, value2, false);
    }

    public boolean isDoubleMetaphoneEqual(String value1, String value2, boolean alternate) {
        return StringUtils.equals(this.doubleMetaphone(value1, alternate), this.doubleMetaphone(value2, alternate));
    }

    public int getMaxCodeLen() {
        return this.maxCodeLen;
    }

    public void setMaxCodeLen(int maxCodeLen) {
        this.maxCodeLen = maxCodeLen;
    }

    private int handleAEIOUY(DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append('A');
        }
        return index + 1;
    }

    private int handleC(String value, DoubleMetaphoneResult result, int index) {
        if (this.conditionC0(value, index)) {
            result.append('K');
            index += 2;
        } else if (index == 0 && DoubleMetaphone.contains(value, index, 6, "io.quarkus.launcher.shaded.CAESAR")) {
            result.append('S');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.CH")) {
            index = this.handleCH(value, result, index);
        } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.CZ") && !DoubleMetaphone.contains(value, index - 2, 4, "io.quarkus.launcher.shaded.WICZ")) {
            result.append('S', 'X');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 3, "io.quarkus.launcher.shaded.CIA")) {
            result.append('X');
            index += 3;
        } else {
            if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.CC") && (index != 1 || this.charAt(value, 0) != 'M')) {
                return this.handleCC(value, result, index);
            }
            if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.CK", "io.quarkus.launcher.shaded.CG", "io.quarkus.launcher.shaded.CQ")) {
                result.append('K');
                index += 2;
            } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.CI", "io.quarkus.launcher.shaded.CE", "io.quarkus.launcher.shaded.CY")) {
                if (DoubleMetaphone.contains(value, index, 3, "io.quarkus.launcher.shaded.CIO", "io.quarkus.launcher.shaded.CIE", "io.quarkus.launcher.shaded.CIA")) {
                    result.append('S', 'X');
                } else {
                    result.append('S');
                }
                index += 2;
            } else {
                result.append('K');
                index = DoubleMetaphone.contains(value, index + 1, 2, "io.quarkus.launcher.shaded. C", "io.quarkus.launcher.shaded. Q", "io.quarkus.launcher.shaded. G") ? (index += 3) : (DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.C", "io.quarkus.launcher.shaded.K", "io.quarkus.launcher.shaded.Q") && !DoubleMetaphone.contains(value, index + 1, 2, "io.quarkus.launcher.shaded.CE", "io.quarkus.launcher.shaded.CI") ? (index += 2) : ++index);
            }
        }
        return index;
    }

    private int handleCC(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index + 2, 1, "io.quarkus.launcher.shaded.I", "io.quarkus.launcher.shaded.E", "io.quarkus.launcher.shaded.H") && !DoubleMetaphone.contains(value, index + 2, 2, "io.quarkus.launcher.shaded.HU")) {
            if (index == 1 && this.charAt(value, index - 1) == 'A' || DoubleMetaphone.contains(value, index - 1, 5, "io.quarkus.launcher.shaded.UCCEE", "io.quarkus.launcher.shaded.UCCES")) {
                result.append("io.quarkus.launcher.shaded.KS");
            } else {
                result.append('X');
            }
            index += 3;
        } else {
            result.append('K');
            index += 2;
        }
        return index;
    }

    private int handleCH(String value, DoubleMetaphoneResult result, int index) {
        if (index > 0 && DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.CHAE")) {
            result.append('K', 'X');
            return index + 2;
        }
        if (this.conditionCH0(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (this.conditionCH1(value, index)) {
            result.append('K');
            return index + 2;
        }
        if (index > 0) {
            if (DoubleMetaphone.contains(value, 0, 2, "io.quarkus.launcher.shaded.MC")) {
                result.append('K');
            } else {
                result.append('X', 'K');
            }
        } else {
            result.append('X');
        }
        return index + 2;
    }

    private int handleD(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.DG")) {
            if (DoubleMetaphone.contains(value, index + 2, 1, "io.quarkus.launcher.shaded.I", "io.quarkus.launcher.shaded.E", "io.quarkus.launcher.shaded.Y")) {
                result.append('J');
                index += 3;
            } else {
                result.append("io.quarkus.launcher.shaded.TK");
                index += 2;
            }
        } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.DT", "io.quarkus.launcher.shaded.DD")) {
            result.append('T');
            index += 2;
        } else {
            result.append('T');
            ++index;
        }
        return index;
    }

    private int handleG(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (this.charAt(value, index + 1) == 'H') {
            index = this.handleGH(value, result, index);
        } else if (this.charAt(value, index + 1) == 'N') {
            if (index == 1 && this.isVowel(this.charAt(value, 0)) && !slavoGermanic) {
                result.append("io.quarkus.launcher.shaded.KN", "io.quarkus.launcher.shaded.N");
            } else if (!DoubleMetaphone.contains(value, index + 2, 2, "io.quarkus.launcher.shaded.EY") && this.charAt(value, index + 1) != 'Y' && !slavoGermanic) {
                result.append("io.quarkus.launcher.shaded.N", "io.quarkus.launcher.shaded.KN");
            } else {
                result.append("io.quarkus.launcher.shaded.KN");
            }
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 2, "io.quarkus.launcher.shaded.LI") && !slavoGermanic) {
            result.append("io.quarkus.launcher.shaded.KL", "io.quarkus.launcher.shaded.L");
            index += 2;
        } else if (index == 0 && (this.charAt(value, index + 1) == 'Y' || DoubleMetaphone.contains(value, index + 1, 2, ES_EP_EB_EL_EY_IB_IL_IN_IE_EI_ER))) {
            result.append('K', 'J');
            index += 2;
        } else if (!(!DoubleMetaphone.contains(value, index + 1, 2, "io.quarkus.launcher.shaded.ER") && this.charAt(value, index + 1) != 'Y' || DoubleMetaphone.contains(value, 0, 6, "io.quarkus.launcher.shaded.DANGER", "io.quarkus.launcher.shaded.RANGER", "io.quarkus.launcher.shaded.MANGER") || DoubleMetaphone.contains(value, index - 1, 1, "io.quarkus.launcher.shaded.E", "io.quarkus.launcher.shaded.I") || DoubleMetaphone.contains(value, index - 1, 3, "io.quarkus.launcher.shaded.RGY", "io.quarkus.launcher.shaded.OGY"))) {
            result.append('K', 'J');
            index += 2;
        } else if (DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.E", "io.quarkus.launcher.shaded.I", "io.quarkus.launcher.shaded.Y") || DoubleMetaphone.contains(value, index - 1, 4, "io.quarkus.launcher.shaded.AGGI", "io.quarkus.launcher.shaded.OGGI")) {
            if (DoubleMetaphone.contains(value, 0, 4, "io.quarkus.launcher.shaded.VAN ", "io.quarkus.launcher.shaded.VON ") || DoubleMetaphone.contains(value, 0, 3, "io.quarkus.launcher.shaded.SCH") || DoubleMetaphone.contains(value, index + 1, 2, "io.quarkus.launcher.shaded.ET")) {
                result.append('K');
            } else if (DoubleMetaphone.contains(value, index + 1, 3, "io.quarkus.launcher.shaded.IER")) {
                result.append('J');
            } else {
                result.append('J', 'K');
            }
            index += 2;
        } else if (this.charAt(value, index + 1) == 'G') {
            index += 2;
            result.append('K');
        } else {
            ++index;
            result.append('K');
        }
        return index;
    }

    private int handleGH(String value, DoubleMetaphoneResult result, int index) {
        if (index > 0 && !this.isVowel(this.charAt(value, index - 1))) {
            result.append('K');
            index += 2;
        } else if (index == 0) {
            if (this.charAt(value, index + 2) == 'I') {
                result.append('J');
            } else {
                result.append('K');
            }
            index += 2;
        } else if (index > 1 && DoubleMetaphone.contains(value, index - 2, 1, "io.quarkus.launcher.shaded.B", "io.quarkus.launcher.shaded.H", "io.quarkus.launcher.shaded.D") || index > 2 && DoubleMetaphone.contains(value, index - 3, 1, "io.quarkus.launcher.shaded.B", "io.quarkus.launcher.shaded.H", "io.quarkus.launcher.shaded.D") || index > 3 && DoubleMetaphone.contains(value, index - 4, 1, "io.quarkus.launcher.shaded.B", "io.quarkus.launcher.shaded.H")) {
            index += 2;
        } else {
            if (index > 2 && this.charAt(value, index - 1) == 'U' && DoubleMetaphone.contains(value, index - 3, 1, "io.quarkus.launcher.shaded.C", "io.quarkus.launcher.shaded.G", "io.quarkus.launcher.shaded.L", "io.quarkus.launcher.shaded.R", "io.quarkus.launcher.shaded.T")) {
                result.append('F');
            } else if (index > 0 && this.charAt(value, index - 1) != 'I') {
                result.append('K');
            }
            index += 2;
        }
        return index;
    }

    private int handleH(String value, DoubleMetaphoneResult result, int index) {
        if ((index == 0 || this.isVowel(this.charAt(value, index - 1))) && this.isVowel(this.charAt(value, index + 1))) {
            result.append('H');
            index += 2;
        } else {
            ++index;
        }
        return index;
    }

    private int handleJ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.JOSE") || DoubleMetaphone.contains(value, 0, 4, "io.quarkus.launcher.shaded.SAN ")) {
            if (index == 0 && this.charAt(value, index + 4) == ' ' || value.length() == 4 || DoubleMetaphone.contains(value, 0, 4, "io.quarkus.launcher.shaded.SAN ")) {
                result.append('H');
            } else {
                result.append('J', 'H');
            }
            ++index;
        } else {
            if (index == 0 && !DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.JOSE")) {
                result.append('J', 'A');
            } else if (this.isVowel(this.charAt(value, index - 1)) && !slavoGermanic && (this.charAt(value, index + 1) == 'A' || this.charAt(value, index + 1) == 'O')) {
                result.append('J', 'H');
            } else if (index == value.length() - 1) {
                result.append('J', ' ');
            } else if (!DoubleMetaphone.contains(value, index + 1, 1, L_T_K_S_N_M_B_Z) && !DoubleMetaphone.contains(value, index - 1, 1, "io.quarkus.launcher.shaded.S", "io.quarkus.launcher.shaded.K", "io.quarkus.launcher.shaded.L")) {
                result.append('J');
            }
            index = this.charAt(value, index + 1) == 'J' ? (index += 2) : ++index;
        }
        return index;
    }

    private int handleL(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 1) == 'L') {
            if (this.conditionL0(value, index)) {
                result.appendPrimary('L');
            } else {
                result.append('L');
            }
            index += 2;
        } else {
            ++index;
            result.append('L');
        }
        return index;
    }

    private int handleP(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 1) == 'H') {
            result.append('F');
            index += 2;
        } else {
            result.append('P');
            index = DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.P", "io.quarkus.launcher.shaded.B") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleR(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (index == value.length() - 1 && !slavoGermanic && DoubleMetaphone.contains(value, index - 2, 2, "io.quarkus.launcher.shaded.IE") && !DoubleMetaphone.contains(value, index - 4, 2, "io.quarkus.launcher.shaded.ME", "io.quarkus.launcher.shaded.MA")) {
            result.appendAlternate('R');
        } else {
            result.append('R');
        }
        return this.charAt(value, index + 1) == 'R' ? index + 2 : index + 1;
    }

    private int handleS(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (DoubleMetaphone.contains(value, index - 1, 3, "io.quarkus.launcher.shaded.ISL", "io.quarkus.launcher.shaded.YSL")) {
            ++index;
        } else if (index == 0 && DoubleMetaphone.contains(value, index, 5, "io.quarkus.launcher.shaded.SUGAR")) {
            result.append('X', 'S');
            ++index;
        } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.SH")) {
            if (DoubleMetaphone.contains(value, index + 1, 4, "io.quarkus.launcher.shaded.HEIM", "io.quarkus.launcher.shaded.HOEK", "io.quarkus.launcher.shaded.HOLM", "io.quarkus.launcher.shaded.HOLZ")) {
                result.append('S');
            } else {
                result.append('X');
            }
            index += 2;
        } else if (DoubleMetaphone.contains(value, index, 3, "io.quarkus.launcher.shaded.SIO", "io.quarkus.launcher.shaded.SIA") || DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.SIAN")) {
            if (slavoGermanic) {
                result.append('S');
            } else {
                result.append('S', 'X');
            }
            index += 3;
        } else if (index == 0 && DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.M", "io.quarkus.launcher.shaded.N", "io.quarkus.launcher.shaded.L", "io.quarkus.launcher.shaded.W") || DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.Z")) {
            result.append('S', 'X');
            index = DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.Z") ? index + 2 : index + 1;
        } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.SC")) {
            index = this.handleSC(value, result, index);
        } else {
            if (index == value.length() - 1 && DoubleMetaphone.contains(value, index - 2, 2, "io.quarkus.launcher.shaded.AI", "io.quarkus.launcher.shaded.OI")) {
                result.appendAlternate('S');
            } else {
                result.append('S');
            }
            index = DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.S", "io.quarkus.launcher.shaded.Z") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleSC(String value, DoubleMetaphoneResult result, int index) {
        if (this.charAt(value, index + 2) == 'H') {
            if (DoubleMetaphone.contains(value, index + 3, 2, "io.quarkus.launcher.shaded.OO", "io.quarkus.launcher.shaded.ER", "io.quarkus.launcher.shaded.EN", "io.quarkus.launcher.shaded.UY", "io.quarkus.launcher.shaded.ED", "io.quarkus.launcher.shaded.EM")) {
                if (DoubleMetaphone.contains(value, index + 3, 2, "io.quarkus.launcher.shaded.ER", "io.quarkus.launcher.shaded.EN")) {
                    result.append("io.quarkus.launcher.shaded.X", "io.quarkus.launcher.shaded.SK");
                } else {
                    result.append("io.quarkus.launcher.shaded.SK");
                }
            } else if (index == 0 && !this.isVowel(this.charAt(value, 3)) && this.charAt(value, 3) != 'W') {
                result.append('X', 'S');
            } else {
                result.append('X');
            }
        } else if (DoubleMetaphone.contains(value, index + 2, 1, "io.quarkus.launcher.shaded.I", "io.quarkus.launcher.shaded.E", "io.quarkus.launcher.shaded.Y")) {
            result.append('S');
        } else {
            result.append("io.quarkus.launcher.shaded.SK");
        }
        return index + 3;
    }

    private int handleT(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.TION")) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains(value, index, 3, "io.quarkus.launcher.shaded.TIA", "io.quarkus.launcher.shaded.TCH")) {
            result.append('X');
            index += 3;
        } else if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.TH") || DoubleMetaphone.contains(value, index, 3, "io.quarkus.launcher.shaded.TTH")) {
            if (DoubleMetaphone.contains(value, index + 2, 2, "io.quarkus.launcher.shaded.OM", "io.quarkus.launcher.shaded.AM") || DoubleMetaphone.contains(value, 0, 4, "io.quarkus.launcher.shaded.VAN ", "io.quarkus.launcher.shaded.VON ") || DoubleMetaphone.contains(value, 0, 3, "io.quarkus.launcher.shaded.SCH")) {
                result.append('T');
            } else {
                result.append('0', 'T');
            }
            index += 2;
        } else {
            result.append('T');
            index = DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.T", "io.quarkus.launcher.shaded.D") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleW(String value, DoubleMetaphoneResult result, int index) {
        if (DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.WR")) {
            result.append('R');
            index += 2;
        } else if (index == 0 && (this.isVowel(this.charAt(value, index + 1)) || DoubleMetaphone.contains(value, index, 2, "io.quarkus.launcher.shaded.WH"))) {
            if (this.isVowel(this.charAt(value, index + 1))) {
                result.append('A', 'F');
            } else {
                result.append('A');
            }
            ++index;
        } else if (index == value.length() - 1 && this.isVowel(this.charAt(value, index - 1)) || DoubleMetaphone.contains(value, index - 1, 5, "io.quarkus.launcher.shaded.EWSKI", "io.quarkus.launcher.shaded.EWSKY", "io.quarkus.launcher.shaded.OWSKI", "io.quarkus.launcher.shaded.OWSKY") || DoubleMetaphone.contains(value, 0, 3, "io.quarkus.launcher.shaded.SCH")) {
            result.appendAlternate('F');
            ++index;
        } else if (DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.WICZ", "io.quarkus.launcher.shaded.WITZ")) {
            result.append("io.quarkus.launcher.shaded.TS", "io.quarkus.launcher.shaded.FX");
            index += 4;
        } else {
            ++index;
        }
        return index;
    }

    private int handleX(String value, DoubleMetaphoneResult result, int index) {
        if (index == 0) {
            result.append('S');
            ++index;
        } else {
            if (index != value.length() - 1 || !DoubleMetaphone.contains(value, index - 3, 3, "io.quarkus.launcher.shaded.IAU", "io.quarkus.launcher.shaded.EAU") && !DoubleMetaphone.contains(value, index - 2, 2, "io.quarkus.launcher.shaded.AU", "io.quarkus.launcher.shaded.OU")) {
                result.append("io.quarkus.launcher.shaded.KS");
            }
            index = DoubleMetaphone.contains(value, index + 1, 1, "io.quarkus.launcher.shaded.C", "io.quarkus.launcher.shaded.X") ? index + 2 : index + 1;
        }
        return index;
    }

    private int handleZ(String value, DoubleMetaphoneResult result, int index, boolean slavoGermanic) {
        if (this.charAt(value, index + 1) == 'H') {
            result.append('J');
            index += 2;
        } else {
            if (DoubleMetaphone.contains(value, index + 1, 2, "io.quarkus.launcher.shaded.ZO", "io.quarkus.launcher.shaded.ZI", "io.quarkus.launcher.shaded.ZA") || slavoGermanic && index > 0 && this.charAt(value, index - 1) != 'T') {
                result.append("io.quarkus.launcher.shaded.S", "io.quarkus.launcher.shaded.TS");
            } else {
                result.append('S');
            }
            index = this.charAt(value, index + 1) == 'Z' ? index + 2 : index + 1;
        }
        return index;
    }

    private boolean conditionC0(String value, int index) {
        if (DoubleMetaphone.contains(value, index, 4, "io.quarkus.launcher.shaded.CHIA")) {
            return true;
        }
        if (index <= 1) {
            return false;
        }
        if (this.isVowel(this.charAt(value, index - 2))) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index - 1, 3, "io.quarkus.launcher.shaded.ACH")) {
            return false;
        }
        char c = this.charAt(value, index + 2);
        return c != 'I' && c != 'E' || DoubleMetaphone.contains(value, index - 2, 6, "io.quarkus.launcher.shaded.BACHER", "io.quarkus.launcher.shaded.MACHER");
    }

    private boolean conditionCH0(String value, int index) {
        if (index != 0) {
            return false;
        }
        if (!DoubleMetaphone.contains(value, index + 1, 5, "io.quarkus.launcher.shaded.HARAC", "io.quarkus.launcher.shaded.HARIS") && !DoubleMetaphone.contains(value, index + 1, 3, "io.quarkus.launcher.shaded.HOR", "io.quarkus.launcher.shaded.HYM", "io.quarkus.launcher.shaded.HIA", "io.quarkus.launcher.shaded.HEM")) {
            return false;
        }
        return !DoubleMetaphone.contains(value, 0, 5, "io.quarkus.launcher.shaded.CHORE");
    }

    private boolean conditionCH1(String value, int index) {
        return DoubleMetaphone.contains(value, 0, 4, "io.quarkus.launcher.shaded.VAN ", "io.quarkus.launcher.shaded.VON ") || DoubleMetaphone.contains(value, 0, 3, "io.quarkus.launcher.shaded.SCH") || DoubleMetaphone.contains(value, index - 2, 6, "io.quarkus.launcher.shaded.ORCHES", "io.quarkus.launcher.shaded.ARCHIT", "io.quarkus.launcher.shaded.ORCHID") || DoubleMetaphone.contains(value, index + 2, 1, "io.quarkus.launcher.shaded.T", "io.quarkus.launcher.shaded.S") || (DoubleMetaphone.contains(value, index - 1, 1, "io.quarkus.launcher.shaded.A", "io.quarkus.launcher.shaded.O", "io.quarkus.launcher.shaded.U", "io.quarkus.launcher.shaded.E") || index == 0) && (DoubleMetaphone.contains(value, index + 2, 1, L_R_N_M_B_H_F_V_W_SPACE) || index + 1 == value.length() - 1);
    }

    private boolean conditionL0(String value, int index) {
        if (index == value.length() - 3 && DoubleMetaphone.contains(value, index - 1, 4, "io.quarkus.launcher.shaded.ILLO", "io.quarkus.launcher.shaded.ILLA", "io.quarkus.launcher.shaded.ALLE")) {
            return true;
        }
        return (DoubleMetaphone.contains(value, value.length() - 2, 2, "io.quarkus.launcher.shaded.AS", "io.quarkus.launcher.shaded.OS") || DoubleMetaphone.contains(value, value.length() - 1, 1, "io.quarkus.launcher.shaded.A", "io.quarkus.launcher.shaded.O")) && DoubleMetaphone.contains(value, index - 1, 4, "io.quarkus.launcher.shaded.ALLE");
    }

    private boolean conditionM0(String value, int index) {
        if (this.charAt(value, index + 1) == 'M') {
            return true;
        }
        return DoubleMetaphone.contains(value, index - 1, 3, "io.quarkus.launcher.shaded.UMB") && (index + 1 == value.length() - 1 || DoubleMetaphone.contains(value, index + 2, 2, "io.quarkus.launcher.shaded.ER"));
    }

    private boolean isSlavoGermanic(String value) {
        return value.indexOf(87) > -1 || value.indexOf(75) > -1 || value.indexOf("io.quarkus.launcher.shaded.CZ") > -1 || value.indexOf("io.quarkus.launcher.shaded.WITZ") > -1;
    }

    private boolean isVowel(char ch) {
        return VOWELS.indexOf(ch) != -1;
    }

    private boolean isSilentStart(String value) {
        boolean result = false;
        for (String element : SILENT_START) {
            if (!value.startsWith(element)) continue;
            result = true;
            break;
        }
        return result;
    }

    private String cleanInput(String input) {
        if (input == null) {
            return null;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return input.toUpperCase(Locale.ENGLISH);
    }

    protected char charAt(String value, int index) {
        if (index < 0 || index >= value.length()) {
            return '\u0000';
        }
        return value.charAt(index);
    }

    protected static boolean contains(String value, int start, int length, String ... criteria) {
        boolean result = false;
        if (start >= 0 && start + length <= value.length()) {
            String target = value.substring(start, start + length);
            for (String element : criteria) {
                if (!target.equals(element)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public class DoubleMetaphoneResult {
        private final StringBuilder primary;
        private final StringBuilder alternate;
        private final int maxLength;

        public DoubleMetaphoneResult(int maxLength) {
            this.primary = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.alternate = new StringBuilder(DoubleMetaphone.this.getMaxCodeLen());
            this.maxLength = maxLength;
        }

        public void append(char value) {
            this.appendPrimary(value);
            this.appendAlternate(value);
        }

        public void append(char primary, char alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(char value) {
            if (this.primary.length() < this.maxLength) {
                this.primary.append(value);
            }
        }

        public void appendAlternate(char value) {
            if (this.alternate.length() < this.maxLength) {
                this.alternate.append(value);
            }
        }

        public void append(String value) {
            this.appendPrimary(value);
            this.appendAlternate(value);
        }

        public void append(String primary, String alternate) {
            this.appendPrimary(primary);
            this.appendAlternate(alternate);
        }

        public void appendPrimary(String value) {
            int addChars = this.maxLength - this.primary.length();
            if (value.length() <= addChars) {
                this.primary.append(value);
            } else {
                this.primary.append(value.substring(0, addChars));
            }
        }

        public void appendAlternate(String value) {
            int addChars = this.maxLength - this.alternate.length();
            if (value.length() <= addChars) {
                this.alternate.append(value);
            } else {
                this.alternate.append(value.substring(0, addChars));
            }
        }

        public String getPrimary() {
            return this.primary.toString();
        }

        public String getAlternate() {
            return this.alternate.toString();
        }

        public boolean isComplete() {
            return this.primary.length() >= this.maxLength && this.alternate.length() >= this.maxLength;
        }
    }
}

