/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.io.filefilter;

import io.quarkus.launcher.shaded.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;

public class MagicNumberFileFilter
extends AbstractFileFilter
implements Serializable {
    private static final long serialVersionUID = -547733176983104172L;
    private final byte[] magicNumbers;
    private final long byteOffset;

    public MagicNumberFileFilter(byte[] magicNumber) {
        this(magicNumber, 0L);
    }

    public MagicNumberFileFilter(String magicNumber) {
        this(magicNumber, 0L);
    }

    public MagicNumberFileFilter(String magicNumber, long offset) {
        if (magicNumber == null) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.The magic number cannot be null");
        }
        if (magicNumber.isEmpty()) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.The magic number must contain at least one byte");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.The offset cannot be negative");
        }
        this.magicNumbers = magicNumber.getBytes(Charset.defaultCharset());
        this.byteOffset = offset;
    }

    public MagicNumberFileFilter(byte[] magicNumber, long offset) {
        if (magicNumber == null) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.The magic number cannot be null");
        }
        if (magicNumber.length == 0) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.The magic number must contain at least one byte");
        }
        if (offset < 0L) {
            throw new IllegalArgumentException("io.quarkus.launcher.shaded.The offset cannot be negative");
        }
        this.magicNumbers = new byte[magicNumber.length];
        System.arraycopy(magicNumber, 0, this.magicNumbers, 0, magicNumber.length);
        this.byteOffset = offset;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean accept(File file) {
        if (file == null) return false;
        if (!file.isFile()) return false;
        if (!file.canRead()) return false;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "io.quarkus.launcher.shaded.r");){
            byte[] fileBytes = new byte[this.magicNumbers.length];
            randomAccessFile.seek(this.byteOffset);
            int read = randomAccessFile.read(fileBytes);
            if (read != this.magicNumbers.length) {
                boolean bl2 = false;
                return bl2;
            }
            boolean bl = Arrays.equals(this.magicNumbers, fileBytes);
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("io.quarkus.launcher.shaded.(");
        builder.append(new String(this.magicNumbers, Charset.defaultCharset()));
        builder.append("io.quarkus.launcher.shaded.,");
        builder.append(this.byteOffset);
        builder.append("io.quarkus.launcher.shaded.)");
        return builder.toString();
    }
}

