/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.lang3;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.SystemUtils;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.arch.Processor;
import java.util.HashMap;
import java.util.Map;

public class ArchUtils {
    private static final Map<String, Processor> ARCH_TO_PROCESSOR = new HashMap<String, Processor>();

    private static void init() {
        ArchUtils.init_X86_32Bit();
        ArchUtils.init_X86_64Bit();
        ArchUtils.init_IA64_32Bit();
        ArchUtils.init_IA64_64Bit();
        ArchUtils.init_PPC_32Bit();
        ArchUtils.init_PPC_64Bit();
    }

    private static void init_X86_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.X86);
        ArchUtils.addProcessors(processor, "io.quarkus.launcher.shaded.x86", "io.quarkus.launcher.shaded.i386", "io.quarkus.launcher.shaded.i486", "io.quarkus.launcher.shaded.i586", "io.quarkus.launcher.shaded.i686", "io.quarkus.launcher.shaded.pentium");
    }

    private static void init_X86_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.X86);
        ArchUtils.addProcessors(processor, "io.quarkus.launcher.shaded.x86_64", "io.quarkus.launcher.shaded.amd64", "io.quarkus.launcher.shaded.em64t", "io.quarkus.launcher.shaded.universal");
    }

    private static void init_IA64_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.IA_64);
        ArchUtils.addProcessors(processor, "io.quarkus.launcher.shaded.ia64_32", "io.quarkus.launcher.shaded.ia64n");
    }

    private static void init_IA64_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.IA_64);
        ArchUtils.addProcessors(processor, "io.quarkus.launcher.shaded.ia64", "io.quarkus.launcher.shaded.ia64w");
    }

    private static void init_PPC_32Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_32, Processor.Type.PPC);
        ArchUtils.addProcessors(processor, "io.quarkus.launcher.shaded.ppc", "io.quarkus.launcher.shaded.power", "io.quarkus.launcher.shaded.powerpc", "io.quarkus.launcher.shaded.power_pc", "io.quarkus.launcher.shaded.power_rs");
    }

    private static void init_PPC_64Bit() {
        Processor processor = new Processor(Processor.Arch.BIT_64, Processor.Type.PPC);
        ArchUtils.addProcessors(processor, "io.quarkus.launcher.shaded.ppc64", "io.quarkus.launcher.shaded.power64", "io.quarkus.launcher.shaded.powerpc64", "io.quarkus.launcher.shaded.power_pc64", "io.quarkus.launcher.shaded.power_rs64");
    }

    private static void addProcessor(String key, Processor processor) {
        if (ARCH_TO_PROCESSOR.containsKey(key)) {
            throw new IllegalStateException("io.quarkus.launcher.shaded.Key " + key + "io.quarkus.launcher.shaded. already exists in processor map");
        }
        ARCH_TO_PROCESSOR.put(key, processor);
    }

    private static void addProcessors(Processor processor, String ... keys) {
        for (String key : keys) {
            ArchUtils.addProcessor(key, processor);
        }
    }

    public static Processor getProcessor() {
        return ArchUtils.getProcessor(SystemUtils.OS_ARCH);
    }

    public static Processor getProcessor(String value) {
        return ARCH_TO_PROCESSOR.get(value);
    }

    static {
        ArchUtils.init();
    }
}

