/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.lang3;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.Validate;

public class ClassPathUtils {
    public static String toFullyQualifiedName(Class<?> context, String resourceName) {
        Validate.notNull(context, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.context");
        Validate.notNull(resourceName, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.resourceName");
        return ClassPathUtils.toFullyQualifiedName(context.getPackage(), resourceName);
    }

    public static String toFullyQualifiedName(Package context, String resourceName) {
        Validate.notNull(context, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.context");
        Validate.notNull(resourceName, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.resourceName");
        return context.getName() + "io.quarkus.launcher.shaded.." + resourceName;
    }

    public static String toFullyQualifiedPath(Class<?> context, String resourceName) {
        Validate.notNull(context, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.context");
        Validate.notNull(resourceName, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.resourceName");
        return ClassPathUtils.toFullyQualifiedPath(context.getPackage(), resourceName);
    }

    public static String toFullyQualifiedPath(Package context, String resourceName) {
        Validate.notNull(context, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.context");
        Validate.notNull(resourceName, "io.quarkus.launcher.shaded.Parameter '%s' must not be null!", "io.quarkus.launcher.shaded.resourceName");
        return context.getName().replace('.', '/') + "io/quarkus/launcher/shaded//" + resourceName;
    }
}

