/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.lang3;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.math.NumberUtils;

public enum JavaVersion {
    JAVA_0_9(1.5f, "io.quarkus.launcher.shaded.0.9"),
    JAVA_1_1(1.1f, "io.quarkus.launcher.shaded.1.1"),
    JAVA_1_2(1.2f, "io.quarkus.launcher.shaded.1.2"),
    JAVA_1_3(1.3f, "io.quarkus.launcher.shaded.1.3"),
    JAVA_1_4(1.4f, "io.quarkus.launcher.shaded.1.4"),
    JAVA_1_5(1.5f, "io.quarkus.launcher.shaded.1.5"),
    JAVA_1_6(1.6f, "io.quarkus.launcher.shaded.1.6"),
    JAVA_1_7(1.7f, "io.quarkus.launcher.shaded.1.7"),
    JAVA_1_8(1.8f, "io.quarkus.launcher.shaded.1.8"),
    JAVA_1_9(9.0f, "io.quarkus.launcher.shaded.9"),
    JAVA_9(9.0f, "io.quarkus.launcher.shaded.9"),
    JAVA_10(10.0f, "io.quarkus.launcher.shaded.10"),
    JAVA_11(11.0f, "io.quarkus.launcher.shaded.11"),
    JAVA_12(12.0f, "io.quarkus.launcher.shaded.12"),
    JAVA_13(13.0f, "io.quarkus.launcher.shaded.13"),
    JAVA_RECENT(JavaVersion.maxVersion(), Float.toString(JavaVersion.maxVersion()));

    private final float value;
    private final String name;

    private JavaVersion(float value, String name) {
        this.value = value;
        this.name = name;
    }

    public boolean atLeast(JavaVersion requiredVersion) {
        return this.value >= requiredVersion.value;
    }

    public boolean atMost(JavaVersion requiredVersion) {
        return this.value <= requiredVersion.value;
    }

    static JavaVersion getJavaVersion(String nom) {
        return JavaVersion.get(nom);
    }

    static JavaVersion get(String nom) {
        int end;
        int firstComma;
        if ("io.quarkus.launcher.shaded.0.9".equals(nom)) {
            return JAVA_0_9;
        }
        if ("io.quarkus.launcher.shaded.1.1".equals(nom)) {
            return JAVA_1_1;
        }
        if ("io.quarkus.launcher.shaded.1.2".equals(nom)) {
            return JAVA_1_2;
        }
        if ("io.quarkus.launcher.shaded.1.3".equals(nom)) {
            return JAVA_1_3;
        }
        if ("io.quarkus.launcher.shaded.1.4".equals(nom)) {
            return JAVA_1_4;
        }
        if ("io.quarkus.launcher.shaded.1.5".equals(nom)) {
            return JAVA_1_5;
        }
        if ("io.quarkus.launcher.shaded.1.6".equals(nom)) {
            return JAVA_1_6;
        }
        if ("io.quarkus.launcher.shaded.1.7".equals(nom)) {
            return JAVA_1_7;
        }
        if ("io.quarkus.launcher.shaded.1.8".equals(nom)) {
            return JAVA_1_8;
        }
        if ("io.quarkus.launcher.shaded.9".equals(nom)) {
            return JAVA_9;
        }
        if ("io.quarkus.launcher.shaded.10".equals(nom)) {
            return JAVA_10;
        }
        if ("io.quarkus.launcher.shaded.11".equals(nom)) {
            return JAVA_11;
        }
        if ("io.quarkus.launcher.shaded.12".equals(nom)) {
            return JAVA_12;
        }
        if ("io.quarkus.launcher.shaded.13".equals(nom)) {
            return JAVA_13;
        }
        if (nom == null) {
            return null;
        }
        float v = JavaVersion.toFloatVersion(nom);
        if ((double)v - 1.0 < 1.0 ? Float.parseFloat(nom.substring((firstComma = Math.max(nom.indexOf(46), nom.indexOf(44))) + 1, end = Math.max(nom.length(), nom.indexOf(44, firstComma)))) > 0.9f : v > 10.0f) {
            return JAVA_RECENT;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }

    private static float maxVersion() {
        float v = JavaVersion.toFloatVersion(System.getProperty("io/quarkus/launcher/shaded/java.specification.version", "io.quarkus.launcher.shaded.99.0"));
        if (v > 0.0f) {
            return v;
        }
        return 99.0f;
    }

    private static float toFloatVersion(String value) {
        int defaultReturnValue = -1;
        if (value.contains("io.quarkus.launcher.shaded..")) {
            String[] toParse = value.split("io.quarkus.launcher.shaded.\\.");
            if (toParse.length >= 2) {
                return NumberUtils.toFloat(toParse[0] + '.' + toParse[1], -1.0f);
            }
        } else {
            return NumberUtils.toFloat(value, -1.0f);
        }
        return -1.0f;
    }
}

