/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.lang3;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.StringUtils;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.AggregateTranslator;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.EntityArrays;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.LookupTranslator;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.NumericEntityEscaper;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.NumericEntityUnescaper;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.OctalUnescaper;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.UnicodeUnescaper;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.text.translate.UnicodeUnpairedSurrogateRemover;
import java.io.IOException;
import java.io.Writer;

@Deprecated
public class StringEscapeUtils {
    public static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator({"io.quarkus.launcher.shaded.\"", "io.quarkus.launcher.shaded.\\\""}, {"io.quarkus.launcher.shaded.\\", "io.quarkus.launcher.shaded.\\\\"}).with(new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE())).with(JavaUnicodeEscaper.outsideOf(32, 127));
    public static final CharSequenceTranslator ESCAPE_ECMASCRIPT = new AggregateTranslator(new LookupTranslator({"io.quarkus.launcher.shaded.'", "io.quarkus.launcher.shaded.\\'"}, {"io.quarkus.launcher.shaded.\"", "io.quarkus.launcher.shaded.\\\""}, {"io.quarkus.launcher.shaded.\\", "io.quarkus.launcher.shaded.\\\\"}, {"io/quarkus/launcher/shaded//", "io/quarkus/launcher/shaded/\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127));
    public static final CharSequenceTranslator ESCAPE_JSON = new AggregateTranslator(new LookupTranslator({"io.quarkus.launcher.shaded.\"", "io.quarkus.launcher.shaded.\\\""}, {"io.quarkus.launcher.shaded.\\", "io.quarkus.launcher.shaded.\\\\"}, {"io/quarkus/launcher/shaded//", "io/quarkus/launcher/shaded/\\/"}), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_ESCAPE()), JavaUnicodeEscaper.outsideOf(32, 127));
    @Deprecated
    public static final CharSequenceTranslator ESCAPE_XML = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()));
    public static final CharSequenceTranslator ESCAPE_XML10 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()), new LookupTranslator({"io.quarkus.launcher.shaded.\u0000", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0001", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0002", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0003", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0004", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0005", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0006", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0007", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\b", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u000b", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\f", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u000e", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u000f", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0010", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0011", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0012", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0013", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0014", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0015", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0016", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0017", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0018", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u0019", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u001a", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u001b", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u001c", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u001d", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u001e", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u001f", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\ufffe", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\uffff", "io.quarkus.launcher.shaded."}), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
    public static final CharSequenceTranslator ESCAPE_XML11 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.APOS_ESCAPE()), new LookupTranslator({"io.quarkus.launcher.shaded.\u0000", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\u000b", "io.quarkus.launcher.shaded.&#11;"}, {"io.quarkus.launcher.shaded.\f", "io.quarkus.launcher.shaded.&#12;"}, {"io.quarkus.launcher.shaded.\ufffe", "io.quarkus.launcher.shaded."}, {"io.quarkus.launcher.shaded.\uffff", "io.quarkus.launcher.shaded."}), NumericEntityEscaper.between(1, 8), NumericEntityEscaper.between(14, 31), NumericEntityEscaper.between(127, 132), NumericEntityEscaper.between(134, 159), new UnicodeUnpairedSurrogateRemover());
    public static final CharSequenceTranslator ESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()));
    public static final CharSequenceTranslator ESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_ESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE()));
    public static final CharSequenceTranslator ESCAPE_CSV = new CsvEscaper();
    public static final CharSequenceTranslator UNESCAPE_JAVA;
    public static final CharSequenceTranslator UNESCAPE_ECMASCRIPT;
    public static final CharSequenceTranslator UNESCAPE_JSON;
    public static final CharSequenceTranslator UNESCAPE_HTML3;
    public static final CharSequenceTranslator UNESCAPE_HTML4;
    public static final CharSequenceTranslator UNESCAPE_XML;
    public static final CharSequenceTranslator UNESCAPE_CSV;

    public static final String escapeJava(String input) {
        return ESCAPE_JAVA.translate(input);
    }

    public static final String escapeEcmaScript(String input) {
        return ESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String escapeJson(String input) {
        return ESCAPE_JSON.translate(input);
    }

    public static final String unescapeJava(String input) {
        return UNESCAPE_JAVA.translate(input);
    }

    public static final String unescapeEcmaScript(String input) {
        return UNESCAPE_ECMASCRIPT.translate(input);
    }

    public static final String unescapeJson(String input) {
        return UNESCAPE_JSON.translate(input);
    }

    public static final String escapeHtml4(String input) {
        return ESCAPE_HTML4.translate(input);
    }

    public static final String escapeHtml3(String input) {
        return ESCAPE_HTML3.translate(input);
    }

    public static final String unescapeHtml4(String input) {
        return UNESCAPE_HTML4.translate(input);
    }

    public static final String unescapeHtml3(String input) {
        return UNESCAPE_HTML3.translate(input);
    }

    @Deprecated
    public static final String escapeXml(String input) {
        return ESCAPE_XML.translate(input);
    }

    public static String escapeXml10(String input) {
        return ESCAPE_XML10.translate(input);
    }

    public static String escapeXml11(String input) {
        return ESCAPE_XML11.translate(input);
    }

    public static final String unescapeXml(String input) {
        return UNESCAPE_XML.translate(input);
    }

    public static final String escapeCsv(String input) {
        return ESCAPE_CSV.translate(input);
    }

    public static final String unescapeCsv(String input) {
        return UNESCAPE_CSV.translate(input);
    }

    static {
        UNESCAPE_ECMASCRIPT = UNESCAPE_JAVA = new AggregateTranslator(new OctalUnescaper(), new UnicodeUnescaper(), new LookupTranslator(EntityArrays.JAVA_CTRL_CHARS_UNESCAPE()), new LookupTranslator({"io.quarkus.launcher.shaded.\\\\", "io.quarkus.launcher.shaded.\\"}, {"io.quarkus.launcher.shaded.\\\"", "io.quarkus.launcher.shaded.\""}, {"io.quarkus.launcher.shaded.\\'", "io.quarkus.launcher.shaded.'"}, {"io.quarkus.launcher.shaded.\\", "io.quarkus.launcher.shaded."}));
        UNESCAPE_JSON = UNESCAPE_JAVA;
        UNESCAPE_HTML3 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_HTML4 = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.ISO8859_1_UNESCAPE()), new LookupTranslator(EntityArrays.HTML40_EXTENDED_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_XML = new AggregateTranslator(new LookupTranslator(EntityArrays.BASIC_UNESCAPE()), new LookupTranslator(EntityArrays.APOS_UNESCAPE()), new NumericEntityUnescaper(new NumericEntityUnescaper.OPTION[0]));
        UNESCAPE_CSV = new CsvUnescaper();
    }

    static class CsvUnescaper
    extends CharSequenceTranslator {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvUnescaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.CsvUnescaper should never reach the [1] index");
            }
            if (input.charAt(0) != '\"' || input.charAt(input.length() - 1) != '\"') {
                out.write(input.toString());
                return Character.codePointCount(input, 0, input.length());
            }
            String quoteless = input.subSequence(1, input.length() - 1).toString();
            if (StringUtils.containsAny((CharSequence)quoteless, CSV_SEARCH_CHARS)) {
                out.write(StringUtils.replace(quoteless, CSV_QUOTE_STR + CSV_QUOTE_STR, CSV_QUOTE_STR));
            } else {
                out.write(input.toString());
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }

    static class CsvEscaper
    extends CharSequenceTranslator {
        private static final char CSV_DELIMITER = ',';
        private static final char CSV_QUOTE = '\"';
        private static final String CSV_QUOTE_STR = String.valueOf('\"');
        private static final char[] CSV_SEARCH_CHARS = new char[]{',', '\"', '\r', '\n'};

        CsvEscaper() {
        }

        @Override
        public int translate(CharSequence input, int index, Writer out) throws IOException {
            if (index != 0) {
                throw new IllegalStateException("io.quarkus.launcher.shaded.CsvEscaper should never reach the [1] index");
            }
            if (StringUtils.containsNone((CharSequence)input.toString(), CSV_SEARCH_CHARS)) {
                out.write(input.toString());
            } else {
                out.write(34);
                out.write(StringUtils.replace(input.toString(), CSV_QUOTE_STR, CSV_QUOTE_STR + CSV_QUOTE_STR));
                out.write(34);
            }
            return Character.codePointCount(input, 0, input.length());
        }
    }
}

