/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.lang3;

import io.quarkus.launcher.shaded.org.apache.commons.lang3.JavaVersion;
import io.quarkus.launcher.shaded.org.apache.commons.lang3.StringUtils;
import java.io.File;

public class SystemUtils {
    private static final String OS_NAME_WINDOWS_PREFIX = "io.quarkus.launcher.shaded.Windows";
    private static final String USER_HOME_KEY = "io.quarkus.launcher.shaded.user.home";
    private static final String USER_DIR_KEY = "io.quarkus.launcher.shaded.user.dir";
    private static final String JAVA_IO_TMPDIR_KEY = "io/quarkus/launcher/shaded/java.io.tmpdir";
    private static final String JAVA_HOME_KEY = "io/quarkus/launcher/shaded/java.home";
    public static final String AWT_TOOLKIT = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.awt.toolkit");
    public static final String FILE_ENCODING = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.file.encoding");
    @Deprecated
    public static final String FILE_SEPARATOR = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.file.separator");
    public static final String JAVA_AWT_FONTS = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.awt.fonts");
    public static final String JAVA_AWT_GRAPHICSENV = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.awt.graphicsenv");
    public static final String JAVA_AWT_HEADLESS = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.awt.headless");
    public static final String JAVA_AWT_PRINTERJOB = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.awt.printerjob");
    public static final String JAVA_CLASS_PATH = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.class.path");
    public static final String JAVA_CLASS_VERSION = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.class.version");
    public static final String JAVA_COMPILER = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.compiler");
    public static final String JAVA_ENDORSED_DIRS = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.endorsed.dirs");
    public static final String JAVA_EXT_DIRS = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.ext.dirs");
    public static final String JAVA_HOME = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.home");
    public static final String JAVA_IO_TMPDIR = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.io.tmpdir");
    public static final String JAVA_LIBRARY_PATH = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.library.path");
    public static final String JAVA_RUNTIME_NAME = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.runtime.name");
    public static final String JAVA_RUNTIME_VERSION = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.runtime.version");
    public static final String JAVA_SPECIFICATION_NAME = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.specification.name");
    public static final String JAVA_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.specification.vendor");
    public static final String JAVA_SPECIFICATION_VERSION = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.specification.version");
    private static final JavaVersion JAVA_SPECIFICATION_VERSION_AS_ENUM = JavaVersion.get(JAVA_SPECIFICATION_VERSION);
    public static final String JAVA_UTIL_PREFS_PREFERENCES_FACTORY = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.util.prefs.PreferencesFactory");
    public static final String JAVA_VENDOR = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vendor");
    public static final String JAVA_VENDOR_URL = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vendor.url");
    public static final String JAVA_VERSION = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.version");
    public static final String JAVA_VM_INFO = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.info");
    public static final String JAVA_VM_NAME = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.name");
    public static final String JAVA_VM_SPECIFICATION_NAME = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.specification.name");
    public static final String JAVA_VM_SPECIFICATION_VENDOR = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.specification.vendor");
    public static final String JAVA_VM_SPECIFICATION_VERSION = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.specification.version");
    public static final String JAVA_VM_VENDOR = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.vendor");
    public static final String JAVA_VM_VERSION = SystemUtils.getSystemProperty("io/quarkus/launcher/shaded/java.vm.version");
    @Deprecated
    public static final String LINE_SEPARATOR = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.line.separator");
    public static final String OS_ARCH = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.os.arch");
    public static final String OS_NAME = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.os.name");
    public static final String OS_VERSION = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.os.version");
    @Deprecated
    public static final String PATH_SEPARATOR = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.path.separator");
    public static final String USER_COUNTRY = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.country") == null ? SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.region") : SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.country");
    public static final String USER_DIR = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.dir");
    public static final String USER_HOME = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.home");
    public static final String USER_LANGUAGE = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.language");
    public static final String USER_NAME = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.name");
    public static final String USER_TIMEZONE = SystemUtils.getSystemProperty("io.quarkus.launcher.shaded.user.timezone");
    public static final boolean IS_JAVA_1_1 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.1");
    public static final boolean IS_JAVA_1_2 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.2");
    public static final boolean IS_JAVA_1_3 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.3");
    public static final boolean IS_JAVA_1_4 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.4");
    public static final boolean IS_JAVA_1_5 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.5");
    public static final boolean IS_JAVA_1_6 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.6");
    public static final boolean IS_JAVA_1_7 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.7");
    public static final boolean IS_JAVA_1_8 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.1.8");
    @Deprecated
    public static final boolean IS_JAVA_1_9 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.9");
    public static final boolean IS_JAVA_9 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.9");
    public static final boolean IS_JAVA_10 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.10");
    public static final boolean IS_JAVA_11 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.11");
    public static final boolean IS_JAVA_12 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.12");
    public static final boolean IS_JAVA_13 = SystemUtils.getJavaVersionMatches("io.quarkus.launcher.shaded.13");
    public static final boolean IS_OS_AIX = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.AIX");
    public static final boolean IS_OS_HP_UX = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.HP-UX");
    public static final boolean IS_OS_400 = SystemUtils.getOsMatchesName("io/quarkus/launcher/shaded/OS/400");
    public static final boolean IS_OS_IRIX = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Irix");
    public static final boolean IS_OS_LINUX = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Linux") || SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.LINUX");
    public static final boolean IS_OS_MAC = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Mac");
    public static final boolean IS_OS_MAC_OSX = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Mac OS X");
    public static final boolean IS_OS_MAC_OSX_CHEETAH = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.0");
    public static final boolean IS_OS_MAC_OSX_PUMA = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.1");
    public static final boolean IS_OS_MAC_OSX_JAGUAR = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.2");
    public static final boolean IS_OS_MAC_OSX_PANTHER = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.3");
    public static final boolean IS_OS_MAC_OSX_TIGER = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.4");
    public static final boolean IS_OS_MAC_OSX_LEOPARD = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.5");
    public static final boolean IS_OS_MAC_OSX_SNOW_LEOPARD = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.6");
    public static final boolean IS_OS_MAC_OSX_LION = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.7");
    public static final boolean IS_OS_MAC_OSX_MOUNTAIN_LION = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.8");
    public static final boolean IS_OS_MAC_OSX_MAVERICKS = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.9");
    public static final boolean IS_OS_MAC_OSX_YOSEMITE = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.10");
    public static final boolean IS_OS_MAC_OSX_EL_CAPITAN = SystemUtils.getOsMatches("io.quarkus.launcher.shaded.Mac OS X", "io.quarkus.launcher.shaded.10.11");
    public static final boolean IS_OS_FREE_BSD = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.FreeBSD");
    public static final boolean IS_OS_OPEN_BSD = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.OpenBSD");
    public static final boolean IS_OS_NET_BSD = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.NetBSD");
    public static final boolean IS_OS_OS2 = SystemUtils.getOsMatchesName("io/quarkus/launcher/shaded/OS/2");
    public static final boolean IS_OS_SOLARIS = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Solaris");
    public static final boolean IS_OS_SUN_OS = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.SunOS");
    public static final boolean IS_OS_UNIX = IS_OS_AIX || IS_OS_HP_UX || IS_OS_IRIX || IS_OS_LINUX || IS_OS_MAC_OSX || IS_OS_SOLARIS || IS_OS_SUN_OS || IS_OS_FREE_BSD || IS_OS_OPEN_BSD || IS_OS_NET_BSD;
    public static final boolean IS_OS_WINDOWS = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows");
    public static final boolean IS_OS_WINDOWS_2000 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 2000");
    public static final boolean IS_OS_WINDOWS_2003 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 2003");
    public static final boolean IS_OS_WINDOWS_2008 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows Server 2008");
    public static final boolean IS_OS_WINDOWS_2012 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows Server 2012");
    public static final boolean IS_OS_WINDOWS_95 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 95");
    public static final boolean IS_OS_WINDOWS_98 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 98");
    public static final boolean IS_OS_WINDOWS_ME = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows Me");
    public static final boolean IS_OS_WINDOWS_NT = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows NT");
    public static final boolean IS_OS_WINDOWS_XP = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows XP");
    public static final boolean IS_OS_WINDOWS_VISTA = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows Vista");
    public static final boolean IS_OS_WINDOWS_7 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 7");
    public static final boolean IS_OS_WINDOWS_8 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 8");
    public static final boolean IS_OS_WINDOWS_10 = SystemUtils.getOsMatchesName("io.quarkus.launcher.shaded.Windows 10");
    public static final boolean IS_OS_ZOS = SystemUtils.getOsMatchesName("io/quarkus/launcher/shaded/z/OS");

    public static File getJavaHome() {
        return new File(System.getProperty(JAVA_HOME_KEY));
    }

    public static String getHostName() {
        return IS_OS_WINDOWS ? System.getenv("io.quarkus.launcher.shaded.COMPUTERNAME") : System.getenv("io.quarkus.launcher.shaded.HOSTNAME");
    }

    public static File getJavaIoTmpDir() {
        return new File(System.getProperty(JAVA_IO_TMPDIR_KEY));
    }

    private static boolean getJavaVersionMatches(String versionPrefix) {
        return SystemUtils.isJavaVersionMatch(JAVA_SPECIFICATION_VERSION, versionPrefix);
    }

    private static boolean getOsMatches(String osNamePrefix, String osVersionPrefix) {
        return SystemUtils.isOSMatch(OS_NAME, OS_VERSION, osNamePrefix, osVersionPrefix);
    }

    private static boolean getOsMatchesName(String osNamePrefix) {
        return SystemUtils.isOSNameMatch(OS_NAME, osNamePrefix);
    }

    private static String getSystemProperty(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static String getEnvironmentVariable(String name, String defaultValue) {
        try {
            String value = System.getenv(name);
            return value == null ? defaultValue : value;
        }
        catch (SecurityException ex) {
            return defaultValue;
        }
    }

    public static File getUserDir() {
        return new File(System.getProperty(USER_DIR_KEY));
    }

    public static File getUserHome() {
        return new File(System.getProperty(USER_HOME_KEY));
    }

    public static boolean isJavaAwtHeadless() {
        return Boolean.TRUE.toString().equals(JAVA_AWT_HEADLESS);
    }

    public static boolean isJavaVersionAtLeast(JavaVersion requiredVersion) {
        return JAVA_SPECIFICATION_VERSION_AS_ENUM.atLeast(requiredVersion);
    }

    public static boolean isJavaVersionAtMost(JavaVersion requiredVersion) {
        return JAVA_SPECIFICATION_VERSION_AS_ENUM.atMost(requiredVersion);
    }

    static boolean isJavaVersionMatch(String version, String versionPrefix) {
        if (version == null) {
            return false;
        }
        return version.startsWith(versionPrefix);
    }

    static boolean isOSMatch(String osName, String osVersion, String osNamePrefix, String osVersionPrefix) {
        if (osName == null || osVersion == null) {
            return false;
        }
        return SystemUtils.isOSNameMatch(osName, osNamePrefix) && SystemUtils.isOSVersionMatch(osVersion, osVersionPrefix);
    }

    static boolean isOSNameMatch(String osName, String osNamePrefix) {
        if (osName == null) {
            return false;
        }
        return osName.startsWith(osNamePrefix);
    }

    static boolean isOSVersionMatch(String osVersion, String osVersionPrefix) {
        if (StringUtils.isEmpty(osVersion)) {
            return false;
        }
        String[] versionPrefixParts = osVersionPrefix.split("io.quarkus.launcher.shaded.\\.");
        String[] versionParts = osVersion.split("io.quarkus.launcher.shaded.\\.");
        for (int i = 0; i < Math.min(versionPrefixParts.length, versionParts.length); ++i) {
            if (versionPrefixParts[i].equals(versionParts[i])) continue;
            return false;
        }
        return true;
    }
}

