/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.commons.logging.impl;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.jboss.logging.Logger;
import java.io.ObjectStreamException;
import java.io.Serializable;

class JBossLog
implements Log,
Serializable {
    private static final long serialVersionUID = 7757100415375072992L;
    private static final String LOGGER_CLASS_NAME = JBossLog.class.getName();
    private final String name;
    private final transient Logger delegate;

    JBossLog(String name) {
        this.delegate = Logger.getLogger(name);
        this.name = name;
    }

    @Override
    public void debug(Object message) {
        this.log(Logger.Level.DEBUG, message);
    }

    @Override
    public void debug(Object message, Throwable t) {
        this.log(Logger.Level.DEBUG, message, t);
    }

    @Override
    public void error(Object message) {
        this.log(Logger.Level.ERROR, message);
    }

    @Override
    public void error(Object message, Throwable t) {
        this.log(Logger.Level.ERROR, message, t);
    }

    @Override
    public void fatal(Object message) {
        this.log(Logger.Level.FATAL, message);
    }

    @Override
    public void fatal(Object message, Throwable t) {
        this.log(Logger.Level.FATAL, message, t);
    }

    @Override
    public void info(Object message) {
        this.log(Logger.Level.INFO, message);
    }

    @Override
    public void info(Object message, Throwable t) {
        this.log(Logger.Level.INFO, message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isEnabled(Logger.Level.DEBUG);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.delegate.isEnabled(Logger.Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.delegate.isEnabled(Logger.Level.FATAL);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.delegate.isEnabled(Logger.Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.delegate.isEnabled(Logger.Level.TRACE);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.delegate.isEnabled(Logger.Level.WARN);
    }

    @Override
    public void trace(Object message) {
        this.log(Logger.Level.TRACE, message);
    }

    @Override
    public void trace(Object message, Throwable t) {
        this.log(Logger.Level.TRACE, message, t);
    }

    @Override
    public void warn(Object message) {
        this.log(Logger.Level.WARN, message);
    }

    @Override
    public void warn(Object message, Throwable t) {
        this.log(Logger.Level.WARN, message, t);
    }

    private void log(Logger.Level level, Object message) {
        this.log(level, message, null);
    }

    private void log(Logger.Level level, Object message, Throwable t) {
        this.delegate.log(level, LOGGER_CLASS_NAME, message, t);
    }

    private Object readResolve() throws ObjectStreamException {
        return LogFactory.getLog(this.name);
    }
}

