/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.client.entity;

import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.entity.HttpEntityWrapper;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHeader;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public class GzipCompressingEntity
extends HttpEntityWrapper {
    private static final String GZIP_CODEC = "io.quarkus.launcher.shaded.gzip";

    public GzipCompressingEntity(HttpEntity entity) {
        super(entity);
    }

    @Override
    public Header getContentEncoding() {
        return new BasicHeader("io.quarkus.launcher.shaded.Content-Encoding", GZIP_CODEC);
    }

    @Override
    public long getContentLength() {
        return -1L;
    }

    @Override
    public boolean isChunked() {
        return true;
    }

    @Override
    public InputStream getContent() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void writeTo(OutputStream outStream) throws IOException {
        Args.notNull(outStream, "io.quarkus.launcher.shaded.Output stream");
        GZIPOutputStream gzip = new GZIPOutputStream(outStream);
        this.wrappedEntity.writeTo(gzip);
        gzip.close();
    }
}

