/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.client.protocol;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequestInterceptor;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.CookieStore;
import io.quarkus.launcher.shaded.org.apache.http.client.config.RequestConfig;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpUriRequest;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.config.Lookup;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.RouteInfo;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieSpec;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieSpecProvider;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.TextUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAddCookies
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Header header;
        int ver;
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("io.quarkus.launcher.shaded.CONNECT")) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        CookieStore cookieStore = clientContext.getCookieStore();
        if (cookieStore == null) {
            this.log.debug("io.quarkus.launcher.shaded.Cookie store not specified in HTTP context");
            return;
        }
        Lookup<CookieSpecProvider> registry = clientContext.getCookieSpecRegistry();
        if (registry == null) {
            this.log.debug("io.quarkus.launcher.shaded.CookieSpec registry not specified in HTTP context");
            return;
        }
        HttpHost targetHost = clientContext.getTargetHost();
        if (targetHost == null) {
            this.log.debug("io.quarkus.launcher.shaded.Target host not set in the context");
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("io.quarkus.launcher.shaded.Connection route not set in the context");
            return;
        }
        RequestConfig config = clientContext.getRequestConfig();
        String policy = config.getCookieSpec();
        if (policy == null) {
            policy = "io.quarkus.launcher.shaded.default";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.CookieSpec selected: " + policy);
        }
        URI requestURI = null;
        if (request instanceof HttpUriRequest) {
            requestURI = ((HttpUriRequest)request).getURI();
        } else {
            try {
                requestURI = new URI(request.getRequestLine().getUri());
            }
            catch (URISyntaxException ignore) {
                // empty catch block
            }
        }
        String path = requestURI != null ? requestURI.getPath() : null;
        String hostName = targetHost.getHostName();
        int port = targetHost.getPort();
        if (port < 0) {
            port = route.getTargetHost().getPort();
        }
        CookieOrigin cookieOrigin = new CookieOrigin(hostName, port >= 0 ? port : 0, !TextUtils.isEmpty(path) ? path : "io/quarkus/launcher/shaded//", route.isSecure());
        CookieSpecProvider provider = registry.lookup(policy);
        if (provider == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Unsupported cookie policy: " + policy);
            }
            return;
        }
        CookieSpec cookieSpec = provider.create(clientContext);
        List<Cookie> cookies = cookieStore.getCookies();
        ArrayList<Cookie> matchedCookies = new ArrayList<Cookie>();
        Date now = new Date();
        boolean expired = false;
        for (Cookie cookie : cookies) {
            if (!cookie.isExpired(now)) {
                if (!cookieSpec.match(cookie, cookieOrigin)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("io.quarkus.launcher.shaded.Cookie " + cookie + "io.quarkus.launcher.shaded. match " + cookieOrigin);
                }
                matchedCookies.add(cookie);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Cookie " + cookie + "io.quarkus.launcher.shaded. expired");
            }
            expired = true;
        }
        if (expired) {
            cookieStore.clearExpired(now);
        }
        if (!matchedCookies.isEmpty()) {
            List<Header> headers = cookieSpec.formatCookies(matchedCookies);
            for (Header header2 : headers) {
                request.addHeader(header2);
            }
        }
        if ((ver = cookieSpec.getVersion()) > 0 && (header = cookieSpec.getVersionHeader()) != null) {
            request.addHeader(header);
        }
        context.setAttribute("io.quarkus.launcher.shaded.http.cookie-spec", cookieSpec);
        context.setAttribute("io.quarkus.launcher.shaded.http.cookie-origin", cookieOrigin);
    }
}

