/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.client.protocol;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequestInterceptor;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthProtocolState;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScheme;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScope;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthState;
import io.quarkus.launcher.shaded.org.apache.http.auth.Credentials;
import io.quarkus.launcher.shaded.org.apache.http.client.AuthCache;
import io.quarkus.launcher.shaded.org.apache.http.client.CredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.RouteInfo;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestAuthCache
implements HttpRequestInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        AuthScheme authScheme;
        AuthScheme authScheme2;
        AuthState targetState;
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache == null) {
            this.log.debug("io.quarkus.launcher.shaded.Auth cache not set in the context");
            return;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            this.log.debug("io.quarkus.launcher.shaded.Credentials provider not set in the context");
            return;
        }
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            this.log.debug("io.quarkus.launcher.shaded.Route info not set in the context");
            return;
        }
        HttpHost target = clientContext.getTargetHost();
        if (target == null) {
            this.log.debug("io.quarkus.launcher.shaded.Target host not set in the context");
            return;
        }
        if (target.getPort() < 0) {
            target = new HttpHost(target.getHostName(), route.getTargetHost().getPort(), target.getSchemeName());
        }
        if ((targetState = clientContext.getTargetAuthState()) != null && targetState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme2 = authCache.get(target)) != null) {
            this.doPreemptiveAuth(target, authScheme2, targetState, credsProvider);
        }
        HttpHost proxy = route.getProxyHost();
        AuthState proxyState = clientContext.getProxyAuthState();
        if (proxy != null && proxyState != null && proxyState.getState() == AuthProtocolState.UNCHALLENGED && (authScheme = authCache.get(proxy)) != null) {
            this.doPreemptiveAuth(proxy, authScheme, proxyState, credsProvider);
        }
    }

    private void doPreemptiveAuth(HttpHost host, AuthScheme authScheme, AuthState authState, CredentialsProvider credsProvider) {
        AuthScope authScope;
        Credentials creds;
        String schemeName = authScheme.getSchemeName();
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Re-using cached '" + schemeName + "io.quarkus.launcher.shaded.' auth scheme for " + host);
        }
        if ((creds = credsProvider.getCredentials(authScope = new AuthScope(host, AuthScope.ANY_REALM, schemeName))) != null) {
            authState.update(authScheme, creds);
        } else {
            this.log.debug("io.quarkus.launcher.shaded.No credentials for preemptive authentication");
        }
    }
}

