/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.client.protocol;

import io.quarkus.launcher.shaded.org.apache.http.HttpEntity;
import io.quarkus.launcher.shaded.org.apache.http.HttpEntityEnclosingRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequestInterceptor;
import io.quarkus.launcher.shaded.org.apache.http.HttpVersion;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolVersion;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.config.RequestConfig;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestExpectContinue
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        if (!request.containsHeader("io.quarkus.launcher.shaded.Expect") && request instanceof HttpEntityEnclosingRequest) {
            HttpClientContext clientContext;
            RequestConfig config;
            ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
            HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
            if (entity != null && entity.getContentLength() != 0L && !ver.lessEquals(HttpVersion.HTTP_1_0) && (config = (clientContext = HttpClientContext.adapt(context)).getRequestConfig()).isExpectContinueEnabled()) {
                request.addHeader("io.quarkus.launcher.shaded.Expect", "io.quarkus.launcher.shaded.100-continue");
            }
        }
    }
}

