/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.client.protocol;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.HttpException;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponseInterceptor;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScheme;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthState;
import io.quarkus.launcher.shaded.org.apache.http.client.AuthCache;
import io.quarkus.launcher.shaded.org.apache.http.conn.scheme.Scheme;
import io.quarkus.launcher.shaded.org.apache.http.conn.scheme.SchemeRegistry;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.BasicAuthCache;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.IOException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseAuthCache
implements HttpResponseInterceptor {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP request");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        AuthCache authCache = (AuthCache)context.getAttribute("io.quarkus.launcher.shaded.http.auth.auth-cache");
        HttpHost target = (HttpHost)context.getAttribute("io.quarkus.launcher.shaded.http.target_host");
        AuthState targetState = (AuthState)context.getAttribute("io.quarkus.launcher.shaded.http.auth.target-scope");
        if (target != null && targetState != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Target auth state: " + (Object)((Object)targetState.getState()));
            }
            if (this.isCachable(targetState)) {
                SchemeRegistry schemeRegistry = (SchemeRegistry)context.getAttribute("io.quarkus.launcher.shaded.http.scheme-registry");
                if (target.getPort() < 0) {
                    Scheme scheme = schemeRegistry.getScheme(target);
                    target = new HttpHost(target.getHostName(), scheme.resolvePort(target.getPort()), target.getSchemeName());
                }
                if (authCache == null) {
                    authCache = new BasicAuthCache();
                    context.setAttribute("io.quarkus.launcher.shaded.http.auth.auth-cache", authCache);
                }
                switch (targetState.getState()) {
                    case CHALLENGED: {
                        this.cache(authCache, target, targetState.getAuthScheme());
                        break;
                    }
                    case FAILURE: {
                        this.uncache(authCache, target, targetState.getAuthScheme());
                    }
                }
            }
        }
        HttpHost proxy = (HttpHost)context.getAttribute("io.quarkus.launcher.shaded.http.proxy_host");
        AuthState proxyState = (AuthState)context.getAttribute("io.quarkus.launcher.shaded.http.auth.proxy-scope");
        if (proxy != null && proxyState != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Proxy auth state: " + (Object)((Object)proxyState.getState()));
            }
            if (this.isCachable(proxyState)) {
                if (authCache == null) {
                    authCache = new BasicAuthCache();
                    context.setAttribute("io.quarkus.launcher.shaded.http.auth.auth-cache", authCache);
                }
                switch (proxyState.getState()) {
                    case CHALLENGED: {
                        this.cache(authCache, proxy, proxyState.getAuthScheme());
                        break;
                    }
                    case FAILURE: {
                        this.uncache(authCache, proxy, proxyState.getAuthScheme());
                    }
                }
            }
        }
    }

    private boolean isCachable(AuthState authState) {
        AuthScheme authScheme = authState.getAuthScheme();
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        return schemeName.equalsIgnoreCase("io.quarkus.launcher.shaded.Basic") || schemeName.equalsIgnoreCase("io.quarkus.launcher.shaded.Digest");
    }

    private void cache(AuthCache authCache, HttpHost host, AuthScheme authScheme) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Caching '" + authScheme.getSchemeName() + "io.quarkus.launcher.shaded.' auth scheme for " + host);
        }
        authCache.put(host, authScheme);
    }

    private void uncache(AuthCache authCache, HttpHost host, AuthScheme authScheme) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Removing from cache '" + authScheme.getSchemeName() + "io.quarkus.launcher.shaded.' auth scheme for " + host);
        }
        authCache.remove(host);
    }
}

