/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.conn.ssl;

import io.quarkus.launcher.shaded.javax.net.SocketFactory;
import io.quarkus.launcher.shaded.javax.net.ssl.HostnameVerifier;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLContext;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLHandshakeException;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLPeerUnverifiedException;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLSession;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLSocket;
import io.quarkus.launcher.shaded.javax.net.ssl.SSLSocketFactory;
import io.quarkus.launcher.shaded.javax.security.auth.x500.X500Principal;
import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.DefaultHostnameVerifier;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.SSLInitializationException;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.StrictHostnameVerifier;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.SubjectName;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.X509HostnameVerifier;
import io.quarkus.launcher.shaded.org.apache.http.conn.util.PublicSuffixMatcherLoader;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.ssl.SSLContexts;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;

@Contract(threading=ThreadingBehavior.SAFE)
public class SSLConnectionSocketFactory
implements LayeredConnectionSocketFactory {
    public static final String TLS = "io.quarkus.launcher.shaded.TLS";
    public static final String SSL = "io.quarkus.launcher.shaded.SSL";
    public static final String SSLV2 = "io.quarkus.launcher.shaded.SSLv2";
    @Deprecated
    public static final X509HostnameVerifier ALLOW_ALL_HOSTNAME_VERIFIER = AllowAllHostnameVerifier.INSTANCE;
    @Deprecated
    public static final X509HostnameVerifier BROWSER_COMPATIBLE_HOSTNAME_VERIFIER = BrowserCompatHostnameVerifier.INSTANCE;
    @Deprecated
    public static final X509HostnameVerifier STRICT_HOSTNAME_VERIFIER = StrictHostnameVerifier.INSTANCE;
    private static final String WEAK_KEY_EXCHANGES = "io.quarkus.launcher.shaded.^(TLS|SSL)_(NULL|ECDH_anon|DH_anon|DH_anon_EXPORT|DHE_RSA_EXPORT|DHE_DSS_EXPORT|DSS_EXPORT|DH_DSS_EXPORT|DH_RSA_EXPORT|RSA_EXPORT|KRB5_EXPORT)_(.*)";
    private static final String WEAK_CIPHERS = "io.quarkus.launcher.shaded.^(TLS|SSL)_(.*)_WITH_(NULL|DES_CBC|DES40_CBC|DES_CBC_40|3DES_EDE_CBC|RC4_128|RC4_40|RC2_CBC_40)_(.*)";
    private static final List<Pattern> WEAK_CIPHER_SUITE_PATTERNS = Collections.unmodifiableList(Arrays.asList(Pattern.compile("io.quarkus.launcher.shaded.^(TLS|SSL)_(NULL|ECDH_anon|DH_anon|DH_anon_EXPORT|DHE_RSA_EXPORT|DHE_DSS_EXPORT|DSS_EXPORT|DH_DSS_EXPORT|DH_RSA_EXPORT|RSA_EXPORT|KRB5_EXPORT)_(.*)", 2), Pattern.compile("io.quarkus.launcher.shaded.^(TLS|SSL)_(.*)_WITH_(NULL|DES_CBC|DES40_CBC|DES_CBC_40|3DES_EDE_CBC|RC4_128|RC4_40|RC2_CBC_40)_(.*)", 2)));
    private final Log log = LogFactory.getLog(this.getClass());
    private final SSLSocketFactory socketfactory;
    private final HostnameVerifier hostnameVerifier;
    private final String[] supportedProtocols;
    private final String[] supportedCipherSuites;

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return new DefaultHostnameVerifier(PublicSuffixMatcherLoader.getDefault());
    }

    public static SSLConnectionSocketFactory getSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory(SSLContexts.createDefault(), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    static boolean isWeakCipherSuite(String cipherSuite) {
        for (Pattern pattern : WEAK_CIPHER_SUITE_PATTERNS) {
            if (!pattern.matcher(cipherSuite).matches()) continue;
            return true;
        }
        return false;
    }

    private static String[] split(String s) {
        if (TextUtils.isBlank(s)) {
            return null;
        }
        return s.split("io.quarkus.launcher.shaded. *, *");
    }

    public static SSLConnectionSocketFactory getSystemSocketFactory() throws SSLInitializationException {
        return new SSLConnectionSocketFactory((SSLSocketFactory)SSLSocketFactory.getDefault(), SSLConnectionSocketFactory.split(System.getProperty("io.quarkus.launcher.shaded.https.protocols")), SSLConnectionSocketFactory.split(System.getProperty("io.quarkus.launcher.shaded.https.cipherSuites")), SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    public SSLConnectionSocketFactory(SSLContext sslContext) {
        this(sslContext, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
    }

    @Deprecated
    public SSLConnectionSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        this(Args.notNull(sslContext, "io.quarkus.launcher.shaded.SSL context").getSocketFactory(), (String[])null, (String[])null, hostnameVerifier);
    }

    @Deprecated
    public SSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        this(Args.notNull(sslContext, "io.quarkus.launcher.shaded.SSL context").getSocketFactory(), supportedProtocols, supportedCipherSuites, hostnameVerifier);
    }

    @Deprecated
    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, X509HostnameVerifier hostnameVerifier) {
        this(socketfactory, (String[])null, (String[])null, hostnameVerifier);
    }

    @Deprecated
    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, X509HostnameVerifier hostnameVerifier) {
        this(socketfactory, supportedProtocols, supportedCipherSuites, (HostnameVerifier)hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLContext sslContext, HostnameVerifier hostnameVerifier) {
        this(Args.notNull(sslContext, "io.quarkus.launcher.shaded.SSL context").getSocketFactory(), null, null, hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLContext sslContext, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
        this(Args.notNull(sslContext, "io.quarkus.launcher.shaded.SSL context").getSocketFactory(), supportedProtocols, supportedCipherSuites, hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, HostnameVerifier hostnameVerifier) {
        this(socketfactory, null, null, hostnameVerifier);
    }

    public SSLConnectionSocketFactory(SSLSocketFactory socketfactory, String[] supportedProtocols, String[] supportedCipherSuites, HostnameVerifier hostnameVerifier) {
        this.socketfactory = Args.notNull(socketfactory, "io.quarkus.launcher.shaded.SSL socket factory");
        this.supportedProtocols = supportedProtocols;
        this.supportedCipherSuites = supportedCipherSuites;
        this.hostnameVerifier = hostnameVerifier != null ? hostnameVerifier : SSLConnectionSocketFactory.getDefaultHostnameVerifier();
    }

    protected void prepareSocket(SSLSocket socket) throws IOException {
    }

    @Override
    public Socket createSocket(HttpContext context) throws IOException {
        return SocketFactory.getDefault().createSocket();
    }

    @Override
    public Socket connectSocket(int connectTimeout, Socket socket, HttpHost host, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpContext context) throws IOException {
        Socket sock;
        Args.notNull(host, "io.quarkus.launcher.shaded.HTTP host");
        Args.notNull(remoteAddress, "io.quarkus.launcher.shaded.Remote address");
        Socket socket2 = sock = socket != null ? socket : this.createSocket(context);
        if (localAddress != null) {
            sock.bind(localAddress);
        }
        try {
            if (connectTimeout > 0 && sock.getSoTimeout() == 0) {
                sock.setSoTimeout(connectTimeout);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Connecting socket to " + remoteAddress + "io.quarkus.launcher.shaded. with timeout " + connectTimeout);
            }
            sock.connect(remoteAddress, connectTimeout);
        }
        catch (IOException ex) {
            try {
                sock.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw ex;
        }
        if (sock instanceof SSLSocket) {
            SSLSocket sslsock = (SSLSocket)sock;
            this.log.debug("io.quarkus.launcher.shaded.Starting handshake");
            sslsock.startHandshake();
            this.verifyHostname(sslsock, host.getHostName());
            return sock;
        }
        return this.createLayeredSocket(sock, host.getHostName(), remoteAddress.getPort(), context);
    }

    @Override
    public Socket createLayeredSocket(Socket socket, String target, int port, HttpContext context) throws IOException {
        SSLSocket sslsock = (SSLSocket)this.socketfactory.createSocket(socket, target, port, true);
        if (this.supportedProtocols != null) {
            sslsock.setEnabledProtocols(this.supportedProtocols);
        } else {
            String[] allProtocols = sslsock.getEnabledProtocols();
            ArrayList<String> enabledProtocols = new ArrayList<String>(allProtocols.length);
            for (String protocol : allProtocols) {
                if (protocol.startsWith(SSL)) continue;
                enabledProtocols.add(protocol);
            }
            if (!enabledProtocols.isEmpty()) {
                sslsock.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
            }
        }
        if (this.supportedCipherSuites != null) {
            sslsock.setEnabledCipherSuites(this.supportedCipherSuites);
        } else {
            String[] allCipherSuites = sslsock.getEnabledCipherSuites();
            ArrayList<String> enabledCipherSuites = new ArrayList<String>(allCipherSuites.length);
            for (String cipherSuite : allCipherSuites) {
                if (SSLConnectionSocketFactory.isWeakCipherSuite(cipherSuite)) continue;
                enabledCipherSuites.add(cipherSuite);
            }
            if (!enabledCipherSuites.isEmpty()) {
                sslsock.setEnabledCipherSuites(enabledCipherSuites.toArray(new String[enabledCipherSuites.size()]));
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Enabled protocols: " + Arrays.asList(sslsock.getEnabledProtocols()));
            this.log.debug("io.quarkus.launcher.shaded.Enabled cipher suites:" + Arrays.asList(sslsock.getEnabledCipherSuites()));
        }
        this.prepareSocket(sslsock);
        this.log.debug("io.quarkus.launcher.shaded.Starting handshake");
        sslsock.startHandshake();
        this.verifyHostname(sslsock, target);
        return sslsock;
    }

    private void verifyHostname(SSLSocket sslsock, String hostname) throws IOException {
        try {
            X509Certificate x509;
            Certificate[] certs;
            SSLSession session = sslsock.getSession();
            if (session == null) {
                InputStream in = sslsock.getInputStream();
                in.available();
                session = sslsock.getSession();
                if (session == null) {
                    sslsock.startHandshake();
                    session = sslsock.getSession();
                }
            }
            if (session == null) {
                throw new SSLHandshakeException("io.quarkus.launcher.shaded.SSL session not available");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Secure session established");
                this.log.debug("io.quarkus.launcher.shaded. negotiated protocol: " + session.getProtocol());
                this.log.debug("io.quarkus.launcher.shaded. negotiated cipher suite: " + session.getCipherSuite());
                try {
                    certs = session.getPeerCertificates();
                    x509 = (X509Certificate)certs[0];
                    X500Principal peer = x509.getSubjectX500Principal();
                    this.log.debug("io.quarkus.launcher.shaded. peer principal: " + peer.toString());
                    Collection<List<?>> altNames1 = x509.getSubjectAlternativeNames();
                    if (altNames1 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames1) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        this.log.debug("io.quarkus.launcher.shaded. peer alternative names: " + altNames);
                    }
                    X500Principal issuer = x509.getIssuerX500Principal();
                    this.log.debug("io.quarkus.launcher.shaded. issuer principal: " + issuer.toString());
                    Collection<List<?>> altNames2 = x509.getIssuerAlternativeNames();
                    if (altNames2 != null) {
                        ArrayList<String> altNames = new ArrayList<String>();
                        for (List<?> aC : altNames2) {
                            if (aC.isEmpty()) continue;
                            altNames.add((String)aC.get(1));
                        }
                        this.log.debug("io.quarkus.launcher.shaded. issuer alternative names: " + altNames);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (!this.hostnameVerifier.verify(hostname, session)) {
                certs = session.getPeerCertificates();
                x509 = (X509Certificate)certs[0];
                List<SubjectName> subjectAlts = DefaultHostnameVerifier.getSubjectAltNames(x509);
                throw new SSLPeerUnverifiedException("io.quarkus.launcher.shaded.Certificate for <" + hostname + "io.quarkus.launcher.shaded.> doesn't match any " + "io.quarkus.launcher.shaded.of the subject alternative names: " + subjectAlts);
            }
        }
        catch (IOException iox) {
            try {
                sslsock.close();
            }
            catch (Exception x) {
                // empty catch block
            }
            throw iox;
        }
    }
}

