/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.conn.util;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.conn.util.DomainType;
import io.quarkus.launcher.shaded.org.apache.http.conn.util.PublicSuffixList;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class PublicSuffixListParser {
    public PublicSuffixList parse(Reader reader) throws IOException {
        String line;
        ArrayList<String> rules = new ArrayList<String>();
        ArrayList<String> exceptions = new ArrayList<String>();
        BufferedReader r = new BufferedReader(reader);
        while ((line = r.readLine()) != null) {
            boolean isException;
            if (line.isEmpty() || line.startsWith("io/quarkus/launcher/shaded///")) continue;
            if (line.startsWith("io.quarkus.launcher.shaded..")) {
                line = line.substring(1);
            }
            if (isException = line.startsWith("io.quarkus.launcher.shaded.!")) {
                line = line.substring(1);
            }
            if (isException) {
                exceptions.add(line);
                continue;
            }
            rules.add(line);
        }
        return new PublicSuffixList(DomainType.UNKNOWN, rules, exceptions);
    }

    public List<PublicSuffixList> parseByType(Reader reader) throws IOException {
        String line;
        ArrayList<PublicSuffixList> result = new ArrayList<PublicSuffixList>(2);
        BufferedReader r = new BufferedReader(reader);
        StringBuilder sb = new StringBuilder(256);
        DomainType domainType = null;
        ArrayList<String> rules = null;
        ArrayList<String> exceptions = null;
        while ((line = r.readLine()) != null) {
            boolean isException;
            if (line.isEmpty()) continue;
            if (line.startsWith("io/quarkus/launcher/shaded///")) {
                if (domainType == null) {
                    if (line.contains("io.quarkus.launcher.shaded.===BEGIN ICANN DOMAINS===")) {
                        domainType = DomainType.ICANN;
                        continue;
                    }
                    if (!line.contains("io.quarkus.launcher.shaded.===BEGIN PRIVATE DOMAINS===")) continue;
                    domainType = DomainType.PRIVATE;
                    continue;
                }
                if (!line.contains("io.quarkus.launcher.shaded.===END ICANN DOMAINS===") && !line.contains("io.quarkus.launcher.shaded.===END PRIVATE DOMAINS===")) continue;
                if (rules != null) {
                    result.add(new PublicSuffixList(domainType, rules, exceptions));
                }
                domainType = null;
                rules = null;
                exceptions = null;
                continue;
            }
            if (domainType == null) continue;
            if (line.startsWith("io.quarkus.launcher.shaded..")) {
                line = line.substring(1);
            }
            if (isException = line.startsWith("io.quarkus.launcher.shaded.!")) {
                line = line.substring(1);
            }
            if (isException) {
                if (exceptions == null) {
                    exceptions = new ArrayList<String>();
                }
                exceptions.add(line);
                continue;
            }
            if (rules == null) {
                rules = new ArrayList<String>();
            }
            rules.add(line);
        }
        return result;
    }
}

