/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import java.io.Serializable;
import java.util.Comparator;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class CookieIdentityComparator
implements Serializable,
Comparator<Cookie> {
    private static final long serialVersionUID = 4466565437490631532L;

    @Override
    public int compare(Cookie c1, Cookie c2) {
        int res = c1.getName().compareTo(c2.getName());
        if (res == 0) {
            String d1 = c1.getDomain();
            if (d1 == null) {
                d1 = "io.quarkus.launcher.shaded.";
            } else if (d1.indexOf(46) == -1) {
                d1 = d1 + "io.quarkus.launcher.shaded..local";
            }
            String d2 = c2.getDomain();
            if (d2 == null) {
                d2 = "io.quarkus.launcher.shaded.";
            } else if (d2.indexOf(46) == -1) {
                d2 = d2 + "io.quarkus.launcher.shaded..local";
            }
            res = d1.compareToIgnoreCase(d2);
        }
        if (res == 0) {
            String p2;
            String p1 = c1.getPath();
            if (p1 == null) {
                p1 = "io/quarkus/launcher/shaded//";
            }
            if ((p2 = c2.getPath()) == null) {
                p2 = "io/quarkus/launcher/shaded//";
            }
            res = p1.compareTo(p2);
        }
        return res;
    }
}

