/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.TextUtils;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public final class CookieOrigin {
    private final String host;
    private final int port;
    private final String path;
    private final boolean secure;

    public CookieOrigin(String host, int port, String path, boolean secure) {
        Args.notBlank(host, "io.quarkus.launcher.shaded.Host");
        Args.notNegative(port, "io.quarkus.launcher.shaded.Port");
        Args.notNull(path, "io.quarkus.launcher.shaded.Path");
        this.host = host.toLowerCase(Locale.ROOT);
        this.port = port;
        this.path = !TextUtils.isBlank(path) ? path : "io/quarkus/launcher/shaded//";
        this.secure = secure;
    }

    public String getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        if (this.secure) {
            buffer.append("io.quarkus.launcher.shaded.(secure)");
        }
        buffer.append(this.host);
        buffer.append(':');
        buffer.append(Integer.toString(this.port));
        buffer.append(this.path);
        buffer.append(']');
        return buffer.toString();
    }
}

