/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl;

import io.quarkus.launcher.shaded.org.apache.http.ConnectionReuseStrategy;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HeaderIterator;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.HttpVersion;
import io.quarkus.launcher.shaded.org.apache.http.ParseException;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolVersion;
import io.quarkus.launcher.shaded.org.apache.http.TokenIterator;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicTokenIterator;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionReuseStrategy
implements ConnectionReuseStrategy {
    public static final DefaultConnectionReuseStrategy INSTANCE = new DefaultConnectionReuseStrategy();

    @Override
    public boolean keepAlive(HttpResponse response, HttpContext context) {
        HeaderIterator headerIterator;
        ProtocolVersion ver;
        block25: {
            HttpRequest request;
            Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
            Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
            if (response.getStatusLine().getStatusCode() == 204) {
                Header teh;
                Header clh = response.getFirstHeader("io.quarkus.launcher.shaded.Content-Length");
                if (clh != null) {
                    try {
                        int contentLen = Integer.parseInt(clh.getValue());
                        if (contentLen > 0) {
                            return false;
                        }
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                if ((teh = response.getFirstHeader("io.quarkus.launcher.shaded.Transfer-Encoding")) != null) {
                    return false;
                }
            }
            if ((request = (HttpRequest)context.getAttribute("io.quarkus.launcher.shaded.http.request")) != null) {
                try {
                    BasicTokenIterator ti = new BasicTokenIterator(request.headerIterator("io.quarkus.launcher.shaded.Connection"));
                    while (ti.hasNext()) {
                        String token = ti.nextToken();
                        if (!"io.quarkus.launcher.shaded.Close".equalsIgnoreCase(token)) continue;
                        return false;
                    }
                }
                catch (ParseException px) {
                    return false;
                }
            }
            ver = response.getStatusLine().getProtocolVersion();
            Header teh = response.getFirstHeader("io.quarkus.launcher.shaded.Transfer-Encoding");
            if (teh != null) {
                if (!"io.quarkus.launcher.shaded.chunked".equalsIgnoreCase(teh.getValue())) {
                    return false;
                }
            } else if (this.canResponseHaveBody(request, response)) {
                Header[] clhs = response.getHeaders("io.quarkus.launcher.shaded.Content-Length");
                if (clhs.length == 1) {
                    Header clh = clhs[0];
                    try {
                        long contentLen = Long.parseLong(clh.getValue());
                        if (contentLen < 0L) {
                            return false;
                        }
                        break block25;
                    }
                    catch (NumberFormatException ex) {
                        return false;
                    }
                }
                return false;
            }
        }
        if (!(headerIterator = response.headerIterator("io.quarkus.launcher.shaded.Connection")).hasNext()) {
            headerIterator = response.headerIterator("io.quarkus.launcher.shaded.Proxy-Connection");
        }
        if (headerIterator.hasNext()) {
            try {
                BasicTokenIterator ti = new BasicTokenIterator(headerIterator);
                boolean keepalive = false;
                while (ti.hasNext()) {
                    String token = ti.nextToken();
                    if ("io.quarkus.launcher.shaded.Close".equalsIgnoreCase(token)) {
                        return false;
                    }
                    if (!"io.quarkus.launcher.shaded.Keep-Alive".equalsIgnoreCase(token)) continue;
                    keepalive = true;
                }
                if (keepalive) {
                    return true;
                }
            }
            catch (ParseException px) {
                return false;
            }
        }
        return !ver.lessEquals(HttpVersion.HTTP_1_0);
    }

    protected TokenIterator createTokenIterator(HeaderIterator hit) {
        return new BasicTokenIterator(hit);
    }

    private boolean canResponseHaveBody(HttpRequest request, HttpResponse response) {
        if (request != null && request.getRequestLine().getMethod().equalsIgnoreCase("io.quarkus.launcher.shaded.HEAD")) {
            return false;
        }
        int status = response.getStatusLine().getStatusCode();
        return status >= 200 && status != 204 && status != 304 && status != 205;
    }
}

