/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl;

import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequestFactory;
import io.quarkus.launcher.shaded.org.apache.http.MethodNotSupportedException;
import io.quarkus.launcher.shaded.org.apache.http.RequestLine;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHttpEntityEnclosingRequest;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultHttpRequestFactory
implements HttpRequestFactory {
    public static final DefaultHttpRequestFactory INSTANCE = new DefaultHttpRequestFactory();
    private static final String[] RFC2616_COMMON_METHODS = new String[]{"io.quarkus.launcher.shaded.GET"};
    private static final String[] RFC2616_ENTITY_ENC_METHODS = new String[]{"io.quarkus.launcher.shaded.POST", "io.quarkus.launcher.shaded.PUT"};
    private static final String[] RFC2616_SPECIAL_METHODS = new String[]{"io.quarkus.launcher.shaded.HEAD", "io.quarkus.launcher.shaded.OPTIONS", "io.quarkus.launcher.shaded.DELETE", "io.quarkus.launcher.shaded.TRACE", "io.quarkus.launcher.shaded.CONNECT"};
    private static final String[] RFC5789_ENTITY_ENC_METHODS = new String[]{"io.quarkus.launcher.shaded.PATCH"};

    private static boolean isOneOf(String[] methods, String method) {
        for (String method2 : methods) {
            if (!method2.equalsIgnoreCase(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HttpRequest newHttpRequest(RequestLine requestline) throws MethodNotSupportedException {
        Args.notNull(requestline, "io.quarkus.launcher.shaded.Request line");
        String method = requestline.getMethod();
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_COMMON_METHODS, method)) {
            return new BasicHttpRequest(requestline);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_ENTITY_ENC_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(requestline);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_SPECIAL_METHODS, method)) {
            return new BasicHttpRequest(requestline);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC5789_ENTITY_ENC_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(requestline);
        }
        throw new MethodNotSupportedException(method + "io.quarkus.launcher.shaded. method not supported");
    }

    @Override
    public HttpRequest newHttpRequest(String method, String uri) throws MethodNotSupportedException {
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_COMMON_METHODS, method)) {
            return new BasicHttpRequest(method, uri);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_ENTITY_ENC_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(method, uri);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC2616_SPECIAL_METHODS, method)) {
            return new BasicHttpRequest(method, uri);
        }
        if (DefaultHttpRequestFactory.isOneOf(RFC5789_ENTITY_ENC_METHODS, method)) {
            return new BasicHttpEntityEnclosingRequest(method, uri);
        }
        throw new MethodNotSupportedException(method + "io.quarkus.launcher.shaded. method not supported");
    }
}

