/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl;

import io.quarkus.launcher.shaded.org.apache.http.ReasonPhraseCatalog;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class EnglishReasonPhraseCatalog
implements ReasonPhraseCatalog {
    public static final EnglishReasonPhraseCatalog INSTANCE = new EnglishReasonPhraseCatalog();
    private static final String[][] REASON_PHRASES = new String[][]{null, new String[3], new String[8], new String[8], new String[25], new String[8]};

    protected EnglishReasonPhraseCatalog() {
    }

    @Override
    public String getReason(int status, Locale loc) {
        Args.check(status >= 100 && status < 600, "io.quarkus.launcher.shaded.Unknown category for status code " + status);
        int category = status / 100;
        int subcode = status - 100 * category;
        String reason = null;
        if (REASON_PHRASES[category].length > subcode) {
            reason = REASON_PHRASES[category][subcode];
        }
        return reason;
    }

    private static void setReason(int status, String reason) {
        int category = status / 100;
        int subcode = status - 100 * category;
        EnglishReasonPhraseCatalog.REASON_PHRASES[category][subcode] = reason;
    }

    static {
        EnglishReasonPhraseCatalog.setReason(200, "io.quarkus.launcher.shaded.OK");
        EnglishReasonPhraseCatalog.setReason(201, "io.quarkus.launcher.shaded.Created");
        EnglishReasonPhraseCatalog.setReason(202, "io.quarkus.launcher.shaded.Accepted");
        EnglishReasonPhraseCatalog.setReason(204, "io.quarkus.launcher.shaded.No Content");
        EnglishReasonPhraseCatalog.setReason(301, "io.quarkus.launcher.shaded.Moved Permanently");
        EnglishReasonPhraseCatalog.setReason(302, "io.quarkus.launcher.shaded.Moved Temporarily");
        EnglishReasonPhraseCatalog.setReason(304, "io.quarkus.launcher.shaded.Not Modified");
        EnglishReasonPhraseCatalog.setReason(400, "io.quarkus.launcher.shaded.Bad Request");
        EnglishReasonPhraseCatalog.setReason(401, "io.quarkus.launcher.shaded.Unauthorized");
        EnglishReasonPhraseCatalog.setReason(403, "io.quarkus.launcher.shaded.Forbidden");
        EnglishReasonPhraseCatalog.setReason(404, "io.quarkus.launcher.shaded.Not Found");
        EnglishReasonPhraseCatalog.setReason(500, "io.quarkus.launcher.shaded.Internal Server Error");
        EnglishReasonPhraseCatalog.setReason(501, "io.quarkus.launcher.shaded.Not Implemented");
        EnglishReasonPhraseCatalog.setReason(502, "io.quarkus.launcher.shaded.Bad Gateway");
        EnglishReasonPhraseCatalog.setReason(503, "io.quarkus.launcher.shaded.Service Unavailable");
        EnglishReasonPhraseCatalog.setReason(100, "io.quarkus.launcher.shaded.Continue");
        EnglishReasonPhraseCatalog.setReason(307, "io.quarkus.launcher.shaded.Temporary Redirect");
        EnglishReasonPhraseCatalog.setReason(405, "io.quarkus.launcher.shaded.Method Not Allowed");
        EnglishReasonPhraseCatalog.setReason(409, "io.quarkus.launcher.shaded.Conflict");
        EnglishReasonPhraseCatalog.setReason(412, "io.quarkus.launcher.shaded.Precondition Failed");
        EnglishReasonPhraseCatalog.setReason(413, "io.quarkus.launcher.shaded.Request Too Long");
        EnglishReasonPhraseCatalog.setReason(414, "io.quarkus.launcher.shaded.Request-URI Too Long");
        EnglishReasonPhraseCatalog.setReason(415, "io.quarkus.launcher.shaded.Unsupported Media Type");
        EnglishReasonPhraseCatalog.setReason(300, "io.quarkus.launcher.shaded.Multiple Choices");
        EnglishReasonPhraseCatalog.setReason(303, "io.quarkus.launcher.shaded.See Other");
        EnglishReasonPhraseCatalog.setReason(305, "io.quarkus.launcher.shaded.Use Proxy");
        EnglishReasonPhraseCatalog.setReason(402, "io.quarkus.launcher.shaded.Payment Required");
        EnglishReasonPhraseCatalog.setReason(406, "io.quarkus.launcher.shaded.Not Acceptable");
        EnglishReasonPhraseCatalog.setReason(407, "io.quarkus.launcher.shaded.Proxy Authentication Required");
        EnglishReasonPhraseCatalog.setReason(408, "io.quarkus.launcher.shaded.Request Timeout");
        EnglishReasonPhraseCatalog.setReason(101, "io.quarkus.launcher.shaded.Switching Protocols");
        EnglishReasonPhraseCatalog.setReason(203, "io.quarkus.launcher.shaded.Non Authoritative Information");
        EnglishReasonPhraseCatalog.setReason(205, "io.quarkus.launcher.shaded.Reset Content");
        EnglishReasonPhraseCatalog.setReason(206, "io.quarkus.launcher.shaded.Partial Content");
        EnglishReasonPhraseCatalog.setReason(504, "io.quarkus.launcher.shaded.Gateway Timeout");
        EnglishReasonPhraseCatalog.setReason(505, "io.quarkus.launcher.shaded.Http Version Not Supported");
        EnglishReasonPhraseCatalog.setReason(410, "io.quarkus.launcher.shaded.Gone");
        EnglishReasonPhraseCatalog.setReason(411, "io.quarkus.launcher.shaded.Length Required");
        EnglishReasonPhraseCatalog.setReason(416, "io.quarkus.launcher.shaded.Requested Range Not Satisfiable");
        EnglishReasonPhraseCatalog.setReason(417, "io.quarkus.launcher.shaded.Expectation Failed");
        EnglishReasonPhraseCatalog.setReason(102, "io.quarkus.launcher.shaded.Processing");
        EnglishReasonPhraseCatalog.setReason(207, "io.quarkus.launcher.shaded.Multi-Status");
        EnglishReasonPhraseCatalog.setReason(422, "io.quarkus.launcher.shaded.Unprocessable Entity");
        EnglishReasonPhraseCatalog.setReason(419, "io.quarkus.launcher.shaded.Insufficient Space On Resource");
        EnglishReasonPhraseCatalog.setReason(420, "io.quarkus.launcher.shaded.Method Failure");
        EnglishReasonPhraseCatalog.setReason(423, "io.quarkus.launcher.shaded.Locked");
        EnglishReasonPhraseCatalog.setReason(507, "io.quarkus.launcher.shaded.Insufficient Storage");
        EnglishReasonPhraseCatalog.setReason(424, "io.quarkus.launcher.shaded.Failed Dependency");
    }
}

