/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.auth;

import io.quarkus.launcher.shaded.org.apache.http.FormattedHeader;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthenticationException;
import io.quarkus.launcher.shaded.org.apache.http.auth.ChallengeState;
import io.quarkus.launcher.shaded.org.apache.http.auth.ContextAwareAuthScheme;
import io.quarkus.launcher.shaded.org.apache.http.auth.Credentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.MalformedChallengeException;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HTTP;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.CharArrayBuffer;
import java.util.Locale;

public abstract class AuthSchemeBase
implements ContextAwareAuthScheme {
    protected ChallengeState challengeState;

    @Deprecated
    public AuthSchemeBase(ChallengeState challengeState) {
        this.challengeState = challengeState;
    }

    public AuthSchemeBase() {
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        int pos;
        CharArrayBuffer buffer;
        Args.notNull(header, "io.quarkus.launcher.shaded.Header");
        String authheader = header.getName();
        if (authheader.equalsIgnoreCase("io.quarkus.launcher.shaded.WWW-Authenticate")) {
            this.challengeState = ChallengeState.TARGET;
        } else if (authheader.equalsIgnoreCase("io.quarkus.launcher.shaded.Proxy-Authenticate")) {
            this.challengeState = ChallengeState.PROXY;
        } else {
            throw new MalformedChallengeException("io.quarkus.launcher.shaded.Unexpected header name: " + authheader);
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            pos = ((FormattedHeader)header).getValuePos();
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedChallengeException("io.quarkus.launcher.shaded.Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            pos = 0;
        }
        while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int beginIndex = pos;
        while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
            ++pos;
        }
        int endIndex = pos;
        String s = buffer.substring(beginIndex, endIndex);
        if (!s.equalsIgnoreCase(this.getSchemeName())) {
            throw new MalformedChallengeException("io.quarkus.launcher.shaded.Invalid scheme identifier: " + s);
        }
        this.parseChallenge(buffer, pos, buffer.length());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        return this.authenticate(credentials, request);
    }

    protected abstract void parseChallenge(CharArrayBuffer var1, int var2, int var3) throws MalformedChallengeException;

    public boolean isProxy() {
        return this.challengeState != null && this.challengeState == ChallengeState.PROXY;
    }

    public ChallengeState getChallengeState() {
        return this.challengeState;
    }

    public String toString() {
        String name = this.getSchemeName();
        return name != null ? name.toUpperCase(Locale.ROOT) : super.toString();
    }
}

