/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.auth;

import io.quarkus.launcher.shaded.org.apache.commons.codec.binary.Base64;
import io.quarkus.launcher.shaded.org.apache.http.Consts;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthenticationException;
import io.quarkus.launcher.shaded.org.apache.http.auth.ChallengeState;
import io.quarkus.launcher.shaded.org.apache.http.auth.Credentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.MalformedChallengeException;
import io.quarkus.launcher.shaded.org.apache.http.impl.auth.RFC2617Scheme;
import io.quarkus.launcher.shaded.org.apache.http.message.BufferedHeader;
import io.quarkus.launcher.shaded.org.apache.http.protocol.BasicHttpContext;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.CharArrayBuffer;
import io.quarkus.launcher.shaded.org.apache.http.util.EncodingUtils;
import java.nio.charset.Charset;

public class BasicScheme
extends RFC2617Scheme {
    private static final long serialVersionUID = -1931571557597830536L;
    private boolean complete;

    public BasicScheme(Charset credentialsCharset) {
        super(credentialsCharset);
        this.complete = false;
    }

    @Deprecated
    public BasicScheme(ChallengeState challengeState) {
        super(challengeState);
    }

    public BasicScheme() {
        this(Consts.ASCII);
    }

    @Override
    public String getSchemeName() {
        return "io.quarkus.launcher.shaded.basic";
    }

    @Override
    public void processChallenge(Header header) throws MalformedChallengeException {
        super.processChallenge(header);
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isConnectionBased() {
        return false;
    }

    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, new BasicHttpContext());
    }

    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Args.notNull(credentials, "io.quarkus.launcher.shaded.Credentials");
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append("io.quarkus.launcher.shaded.:");
        tmp.append(credentials.getPassword() == null ? "io.quarkus.launcher.shaded.null" : credentials.getPassword());
        Base64 base64codec = new Base64(0);
        byte[] base64password = base64codec.encode(EncodingUtils.getBytes(tmp.toString(), this.getCredentialsCharset(request)));
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (this.isProxy()) {
            buffer.append("io.quarkus.launcher.shaded.Proxy-Authorization");
        } else {
            buffer.append("io.quarkus.launcher.shaded.Authorization");
        }
        buffer.append("io.quarkus.launcher.shaded.: Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }

    @Deprecated
    public static Header authenticate(Credentials credentials, String charset, boolean proxy) {
        Args.notNull(credentials, "io.quarkus.launcher.shaded.Credentials");
        Args.notNull(charset, "io.quarkus.launcher.shaded.charset");
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append("io.quarkus.launcher.shaded.:");
        tmp.append(credentials.getPassword() == null ? "io.quarkus.launcher.shaded.null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64(EncodingUtils.getBytes(tmp.toString(), charset), false);
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        if (proxy) {
            buffer.append("io.quarkus.launcher.shaded.Proxy-Authorization");
        } else {
            buffer.append("io.quarkus.launcher.shaded.Authorization");
        }
        buffer.append("io.quarkus.launcher.shaded.: Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("io.quarkus.launcher.shaded.BASIC [complete=").append(this.complete).append("io.quarkus.launcher.shaded.]");
        return builder.toString();
    }
}

