/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.client;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.FormattedHeader;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthOption;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScheme;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthSchemeProvider;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScope;
import io.quarkus.launcher.shaded.org.apache.http.auth.Credentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.MalformedChallengeException;
import io.quarkus.launcher.shaded.org.apache.http.client.AuthCache;
import io.quarkus.launcher.shaded.org.apache.http.client.AuthenticationStrategy;
import io.quarkus.launcher.shaded.org.apache.http.client.CredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.client.config.RequestConfig;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.config.Lookup;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.BasicAuthCache;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HTTP;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.CharArrayBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
abstract class AuthenticationStrategyImpl
implements AuthenticationStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final List<String> DEFAULT_SCHEME_PRIORITY = Collections.unmodifiableList(Arrays.asList("io.quarkus.launcher.shaded.Negotiate", "io.quarkus.launcher.shaded.Kerberos", "io.quarkus.launcher.shaded.NTLM", "io.quarkus.launcher.shaded.CredSSP", "io.quarkus.launcher.shaded.Digest", "io.quarkus.launcher.shaded.Basic"));
    private final int challengeCode;
    private final String headerName;

    AuthenticationStrategyImpl(int challengeCode, String headerName) {
        this.challengeCode = challengeCode;
        this.headerName = headerName;
    }

    @Override
    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response, HttpContext context) {
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        int status = response.getStatusLine().getStatusCode();
        return status == this.challengeCode;
    }

    @Override
    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        Header[] headers = response.getHeaders(this.headerName);
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (Header header : headers) {
            int pos;
            CharArrayBuffer buffer;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedChallengeException("io.quarkus.launcher.shaded.Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace(buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s = buffer.substring(beginIndex, endIndex);
            map.put(s.toLowerCase(Locale.ROOT), header);
        }
        return map;
    }

    abstract Collection<String> getPreferredAuthSchemes(RequestConfig var1);

    @Override
    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        Args.notNull(challenges, "io.quarkus.launcher.shaded.Map of auth challenges");
        Args.notNull(authhost, "io.quarkus.launcher.shaded.Host");
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        LinkedList<AuthOption> options = new LinkedList<AuthOption>();
        Lookup<AuthSchemeProvider> registry = clientContext.getAuthSchemeRegistry();
        if (registry == null) {
            this.log.debug("io.quarkus.launcher.shaded.Auth scheme registry not set in the context");
            return options;
        }
        CredentialsProvider credsProvider = clientContext.getCredentialsProvider();
        if (credsProvider == null) {
            this.log.debug("io.quarkus.launcher.shaded.Credentials provider not set in the context");
            return options;
        }
        RequestConfig config = clientContext.getRequestConfig();
        Collection<String> authPrefs = this.getPreferredAuthSchemes(config);
        if (authPrefs == null) {
            authPrefs = DEFAULT_SCHEME_PRIORITY;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Authentication schemes in the order of preference: " + authPrefs);
        }
        for (String id : authPrefs) {
            Header challenge = challenges.get(id.toLowerCase(Locale.ROOT));
            if (challenge != null) {
                AuthSchemeProvider authSchemeProvider = registry.lookup(id);
                if (authSchemeProvider == null) {
                    if (!this.log.isWarnEnabled()) continue;
                    this.log.warn("io.quarkus.launcher.shaded.Authentication scheme " + id + "io.quarkus.launcher.shaded. not supported");
                    continue;
                }
                AuthScheme authScheme = authSchemeProvider.create(context);
                authScheme.processChallenge(challenge);
                AuthScope authScope = new AuthScope(authhost, authScheme.getRealm(), authScheme.getSchemeName());
                Credentials credentials = credsProvider.getCredentials(authScope);
                if (credentials == null) continue;
                options.add(new AuthOption(authScheme, credentials));
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("io.quarkus.launcher.shaded.Challenge for " + id + "io.quarkus.launcher.shaded. authentication scheme not available");
        }
        return options;
    }

    @Override
    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        Args.notNull(authhost, "io.quarkus.launcher.shaded.Host");
        Args.notNull(authScheme, "io.quarkus.launcher.shaded.Auth scheme");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        if (this.isCachable(authScheme)) {
            AuthCache authCache = clientContext.getAuthCache();
            if (authCache == null) {
                authCache = new BasicAuthCache();
                clientContext.setAuthCache(authCache);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Caching '" + authScheme.getSchemeName() + "io.quarkus.launcher.shaded.' auth scheme for " + authhost);
            }
            authCache.put(authhost, authScheme);
        }
    }

    protected boolean isCachable(AuthScheme authScheme) {
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        return schemeName.equalsIgnoreCase("io.quarkus.launcher.shaded.Basic");
    }

    @Override
    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        Args.notNull(authhost, "io.quarkus.launcher.shaded.Host");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        AuthCache authCache = clientContext.getAuthCache();
        if (authCache != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Clearing cached auth scheme for " + authhost);
            }
            authCache.remove(authhost);
        }
    }
}

