/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.client;

import io.quarkus.launcher.shaded.org.apache.http.HeaderElement;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.conn.ConnectionKeepAliveStrategy;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHeaderElementIterator;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("io.quarkus.launcher.shaded.Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("io.quarkus.launcher.shaded.timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

