/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.client;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.CircularRedirectException;
import io.quarkus.launcher.shaded.org.apache.http.client.RedirectHandler;
import io.quarkus.launcher.shaded.org.apache.http.client.utils.URIUtils;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.RedirectLocations;
import io.quarkus.launcher.shaded.org.apache.http.params.HttpParams;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.Asserts;
import java.net.URI;
import java.net.URISyntaxException;

@Deprecated
@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultRedirectHandler
implements RedirectHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "io.quarkus.launcher.shaded.http.protocol.redirect-locations";

    @Override
    public boolean isRedirectRequested(HttpResponse response, HttpContext context) {
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        int statusCode = response.getStatusLine().getStatusCode();
        switch (statusCode) {
            case 301: 
            case 302: 
            case 307: {
                HttpRequest request = (HttpRequest)context.getAttribute("io.quarkus.launcher.shaded.http.request");
                String method = request.getRequestLine().getMethod();
                return method.equalsIgnoreCase("io.quarkus.launcher.shaded.GET") || method.equalsIgnoreCase("io.quarkus.launcher.shaded.HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    @Override
    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri;
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        Header locationHeader = response.getFirstHeader("io.quarkus.launcher.shaded.location");
        if (locationHeader == null) {
            throw new ProtocolException("io.quarkus.launcher.shaded.Received redirect response " + response.getStatusLine() + "io.quarkus.launcher.shaded. but no location header");
        }
        String location = locationHeader.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Redirect requested to location '" + location + "io.quarkus.launcher.shaded.'");
        }
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("io.quarkus.launcher.shaded.Invalid redirect URI: " + location, ex);
        }
        HttpParams params = response.getParams();
        if (!uri.isAbsolute()) {
            if (params.isParameterTrue("io.quarkus.launcher.shaded.http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("io.quarkus.launcher.shaded.Relative redirect location '" + uri + "io.quarkus.launcher.shaded.' not allowed");
            }
            HttpHost target = (HttpHost)context.getAttribute("io.quarkus.launcher.shaded.http.target_host");
            Asserts.notNull(target, "io.quarkus.launcher.shaded.Target host");
            HttpRequest request = (HttpRequest)context.getAttribute("io.quarkus.launcher.shaded.http.request");
            try {
                URI requestURI = new URI(request.getRequestLine().getUri());
                URI absoluteRequestURI = URIUtils.rewriteURI(requestURI, target, URIUtils.DROP_FRAGMENT_AND_NORMALIZE);
                uri = URIUtils.resolve(absoluteRequestURI, uri);
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), ex);
            }
        }
        if (params.isParameterFalse("io.quarkus.launcher.shaded.http.protocol.allow-circular-redirects")) {
            URI redirectURI;
            RedirectLocations redirectLocations = (RedirectLocations)context.getAttribute(REDIRECT_LOCATIONS);
            if (redirectLocations == null) {
                redirectLocations = new RedirectLocations();
                context.setAttribute(REDIRECT_LOCATIONS, redirectLocations);
            }
            if (uri.getFragment() != null) {
                try {
                    HttpHost target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    redirectURI = URIUtils.rewriteURI(uri, target, URIUtils.DROP_FRAGMENT_AND_NORMALIZE);
                }
                catch (URISyntaxException ex) {
                    throw new ProtocolException(ex.getMessage(), ex);
                }
            } else {
                redirectURI = uri;
            }
            if (redirectLocations.contains(redirectURI)) {
                throw new CircularRedirectException("io.quarkus.launcher.shaded.Circular redirect to '" + redirectURI + "io.quarkus.launcher.shaded.'");
            }
            redirectLocations.add(redirectURI);
        }
        return uri;
    }
}

