/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.client;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.HttpResponse;
import io.quarkus.launcher.shaded.org.apache.http.ProtocolException;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.CircularRedirectException;
import io.quarkus.launcher.shaded.org.apache.http.client.RedirectStrategy;
import io.quarkus.launcher.shaded.org.apache.http.client.config.RequestConfig;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpGet;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpHead;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.HttpUriRequest;
import io.quarkus.launcher.shaded.org.apache.http.client.methods.RequestBuilder;
import io.quarkus.launcher.shaded.org.apache.http.client.protocol.HttpClientContext;
import io.quarkus.launcher.shaded.org.apache.http.client.utils.URIUtils;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.RedirectLocations;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.Asserts;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultRedirectStrategy
implements RedirectStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final int SC_PERMANENT_REDIRECT = 308;
    @Deprecated
    public static final String REDIRECT_LOCATIONS = "io.quarkus.launcher.shaded.http.protocol.redirect-locations";
    public static final DefaultRedirectStrategy INSTANCE = new DefaultRedirectStrategy();
    private final String[] redirectMethods;

    public DefaultRedirectStrategy() {
        this(new String[]{"io.quarkus.launcher.shaded.GET", "io.quarkus.launcher.shaded.HEAD"});
    }

    public DefaultRedirectStrategy(String[] redirectMethods) {
        Object[] tmp = (String[])redirectMethods.clone();
        Arrays.sort(tmp);
        this.redirectMethods = tmp;
    }

    @Override
    public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        int statusCode = response.getStatusLine().getStatusCode();
        String method = request.getRequestLine().getMethod();
        Header locationHeader = response.getFirstHeader("io.quarkus.launcher.shaded.location");
        switch (statusCode) {
            case 302: {
                return this.isRedirectable(method) && locationHeader != null;
            }
            case 301: 
            case 307: 
            case 308: {
                return this.isRedirectable(method);
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    public URI getLocationURI(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        Args.notNull(request, "io.quarkus.launcher.shaded.HTTP request");
        Args.notNull(response, "io.quarkus.launcher.shaded.HTTP response");
        Args.notNull(context, "io.quarkus.launcher.shaded.HTTP context");
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        Header locationHeader = response.getFirstHeader("io.quarkus.launcher.shaded.location");
        if (locationHeader == null) {
            throw new ProtocolException("io.quarkus.launcher.shaded.Received redirect response " + response.getStatusLine() + "io.quarkus.launcher.shaded. but no location header");
        }
        String location = locationHeader.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Redirect requested to location '" + location + "io.quarkus.launcher.shaded.'");
        }
        RequestConfig config = clientContext.getRequestConfig();
        URI uri = this.createLocationURI(location);
        try {
            if (config.isNormalizeUri()) {
                uri = URIUtils.normalizeSyntax(uri);
            }
            if (!uri.isAbsolute()) {
                if (!config.isRelativeRedirectsAllowed()) {
                    throw new ProtocolException("io.quarkus.launcher.shaded.Relative redirect location '" + uri + "io.quarkus.launcher.shaded.' not allowed");
                }
                HttpHost target = clientContext.getTargetHost();
                Asserts.notNull(target, "io.quarkus.launcher.shaded.Target host");
                URI requestURI = new URI(request.getRequestLine().getUri());
                URI absoluteRequestURI = URIUtils.rewriteURI(requestURI, target, config.isNormalizeUri() ? URIUtils.NORMALIZE : URIUtils.NO_FLAGS);
                uri = URIUtils.resolve(absoluteRequestURI, uri);
            }
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), ex);
        }
        RedirectLocations redirectLocations = (RedirectLocations)clientContext.getAttribute(REDIRECT_LOCATIONS);
        if (redirectLocations == null) {
            redirectLocations = new RedirectLocations();
            context.setAttribute(REDIRECT_LOCATIONS, redirectLocations);
        }
        if (!config.isCircularRedirectsAllowed() && redirectLocations.contains(uri)) {
            throw new CircularRedirectException("io.quarkus.launcher.shaded.Circular redirect to '" + uri + "io.quarkus.launcher.shaded.'");
        }
        redirectLocations.add(uri);
        return uri;
    }

    protected URI createLocationURI(String location) throws ProtocolException {
        try {
            return new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("io.quarkus.launcher.shaded.Invalid redirect URI: " + location, ex);
        }
    }

    protected boolean isRedirectable(String method) {
        return Arrays.binarySearch(this.redirectMethods, method) >= 0;
    }

    @Override
    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
        URI uri = this.getLocationURI(request, response, context);
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("io.quarkus.launcher.shaded.HEAD")) {
            return new HttpHead(uri);
        }
        if (method.equalsIgnoreCase("io.quarkus.launcher.shaded.GET")) {
            return new HttpGet(uri);
        }
        int status = response.getStatusLine().getStatusCode();
        return status == 307 || status == 308 ? RequestBuilder.copy(request).setUri(uri).build() : new HttpGet(uri);
    }
}

