/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.client;

import io.quarkus.launcher.shaded.org.apache.http.HttpRequest;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class StandardHttpRequestRetryHandler
extends DefaultHttpRequestRetryHandler {
    private final Map<String, Boolean> idempotentMethods = new ConcurrentHashMap<String, Boolean>();

    public StandardHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        super(retryCount, requestSentRetryEnabled);
        this.idempotentMethods.put("io.quarkus.launcher.shaded.GET", Boolean.TRUE);
        this.idempotentMethods.put("io.quarkus.launcher.shaded.HEAD", Boolean.TRUE);
        this.idempotentMethods.put("io.quarkus.launcher.shaded.PUT", Boolean.TRUE);
        this.idempotentMethods.put("io.quarkus.launcher.shaded.DELETE", Boolean.TRUE);
        this.idempotentMethods.put("io.quarkus.launcher.shaded.OPTIONS", Boolean.TRUE);
        this.idempotentMethods.put("io.quarkus.launcher.shaded.TRACE", Boolean.TRUE);
    }

    public StandardHttpRequestRetryHandler() {
        this(3, false);
    }

    @Override
    protected boolean handleAsIdempotent(HttpRequest request) {
        String method = request.getRequestLine().getMethod().toUpperCase(Locale.ROOT);
        Boolean b = this.idempotentMethods.get(method);
        return b != null && b != false;
    }
}

