/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.client;

import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.auth.AuthScope;
import io.quarkus.launcher.shaded.org.apache.http.auth.Credentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.NTCredentials;
import io.quarkus.launcher.shaded.org.apache.http.auth.UsernamePasswordCredentials;
import io.quarkus.launcher.shaded.org.apache.http.client.CredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.impl.client.BasicCredentialsProvider;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@Contract(threading=ThreadingBehavior.SAFE)
public class SystemDefaultCredentialsProvider
implements CredentialsProvider {
    private static final Map<String, String> SCHEME_MAP = new ConcurrentHashMap<String, String>();
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    private static String translateScheme(String key) {
        if (key == null) {
            return null;
        }
        String s = SCHEME_MAP.get(key);
        return s != null ? s : key;
    }

    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        this.internal.setCredentials(authscope, credentials);
    }

    private static PasswordAuthentication getSystemCreds(String protocol, AuthScope authscope, Authenticator.RequestorType requestorType) {
        return Authenticator.requestPasswordAuthentication(authscope.getHost(), null, authscope.getPort(), protocol, null, SystemDefaultCredentialsProvider.translateScheme(authscope.getScheme()), null, requestorType);
    }

    @Override
    public Credentials getCredentials(AuthScope authscope) {
        Args.notNull(authscope, "io.quarkus.launcher.shaded.Auth scope");
        Credentials localcreds = this.internal.getCredentials(authscope);
        if (localcreds != null) {
            return localcreds;
        }
        String host = authscope.getHost();
        if (host != null) {
            HttpHost origin = authscope.getOrigin();
            String protocol = origin != null ? origin.getSchemeName() : (authscope.getPort() == 443 ? "io.quarkus.launcher.shaded.https" : "io.quarkus.launcher.shaded.http");
            PasswordAuthentication systemcreds = SystemDefaultCredentialsProvider.getSystemCreds(protocol, authscope, Authenticator.RequestorType.SERVER);
            if (systemcreds == null) {
                systemcreds = SystemDefaultCredentialsProvider.getSystemCreds(protocol, authscope, Authenticator.RequestorType.PROXY);
            }
            if (systemcreds == null && (systemcreds = SystemDefaultCredentialsProvider.getProxyCredentials("io.quarkus.launcher.shaded.http", authscope)) == null) {
                systemcreds = SystemDefaultCredentialsProvider.getProxyCredentials("io.quarkus.launcher.shaded.https", authscope);
            }
            if (systemcreds != null) {
                String domain = System.getProperty("io.quarkus.launcher.shaded.http.auth.ntlm.domain");
                if (domain != null) {
                    return new NTCredentials(systemcreds.getUserName(), new String(systemcreds.getPassword()), null, domain);
                }
                return "io.quarkus.launcher.shaded.NTLM".equalsIgnoreCase(authscope.getScheme()) ? new NTCredentials(systemcreds.getUserName(), new String(systemcreds.getPassword()), null, null) : new UsernamePasswordCredentials(systemcreds.getUserName(), new String(systemcreds.getPassword()));
            }
        }
        return null;
    }

    private static PasswordAuthentication getProxyCredentials(String protocol, AuthScope authscope) {
        String proxyHost = System.getProperty(protocol + "io.quarkus.launcher.shaded..proxyHost");
        if (proxyHost == null) {
            return null;
        }
        String proxyPort = System.getProperty(protocol + "io.quarkus.launcher.shaded..proxyPort");
        if (proxyPort == null) {
            return null;
        }
        try {
            AuthScope systemScope = new AuthScope(proxyHost, Integer.parseInt(proxyPort));
            if (authscope.match(systemScope) >= 0) {
                String proxyUser = System.getProperty(protocol + "io.quarkus.launcher.shaded..proxyUser");
                if (proxyUser == null) {
                    return null;
                }
                String proxyPassword = System.getProperty(protocol + "io.quarkus.launcher.shaded..proxyPassword");
                return new PasswordAuthentication(proxyUser, proxyPassword != null ? proxyPassword.toCharArray() : new char[]{});
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    static {
        SCHEME_MAP.put("io.quarkus.launcher.shaded.Basic".toUpperCase(Locale.ROOT), "io.quarkus.launcher.shaded.Basic");
        SCHEME_MAP.put("io.quarkus.launcher.shaded.Digest".toUpperCase(Locale.ROOT), "io.quarkus.launcher.shaded.Digest");
        SCHEME_MAP.put("io.quarkus.launcher.shaded.NTLM".toUpperCase(Locale.ROOT), "io.quarkus.launcher.shaded.NTLM");
        SCHEME_MAP.put("io.quarkus.launcher.shaded.Negotiate".toUpperCase(Locale.ROOT), "io.quarkus.launcher.shaded.SPNEGO");
        SCHEME_MAP.put("io.quarkus.launcher.shaded.Kerberos".toUpperCase(Locale.ROOT), "io.quarkus.launcher.shaded.Kerberos");
    }
}

