/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.conn;

import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.conn.ClientConnectionOperator;
import io.quarkus.launcher.shaded.org.apache.http.conn.OperatedClientConnection;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.HttpRoute;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.RouteTracker;
import io.quarkus.launcher.shaded.org.apache.http.params.HttpParams;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.Asserts;
import java.io.IOException;
import java.io.InterruptedIOException;

@Deprecated
public abstract class AbstractPoolEntry {
    protected final ClientConnectionOperator connOperator;
    protected final OperatedClientConnection connection;
    protected volatile HttpRoute route;
    protected volatile Object state;
    protected volatile RouteTracker tracker;

    protected AbstractPoolEntry(ClientConnectionOperator connOperator, HttpRoute route) {
        Args.notNull(connOperator, "io.quarkus.launcher.shaded.Connection operator");
        this.connOperator = connOperator;
        this.connection = connOperator.createConnection();
        this.route = route;
        this.tracker = null;
    }

    public Object getState() {
        return this.state;
    }

    public void setState(Object state) {
        this.state = state;
    }

    public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
        Args.notNull(route, "io.quarkus.launcher.shaded.Route");
        Args.notNull(params, "io.quarkus.launcher.shaded.HTTP parameters");
        if (this.tracker != null) {
            Asserts.check(!this.tracker.isConnected(), "io.quarkus.launcher.shaded.Connection already open");
        }
        this.tracker = new RouteTracker(route);
        HttpHost proxy = route.getProxyHost();
        this.connOperator.openConnection(this.connection, proxy != null ? proxy : route.getTargetHost(), route.getLocalAddress(), context, params);
        RouteTracker localTracker = this.tracker;
        if (localTracker == null) {
            throw new InterruptedIOException("io.quarkus.launcher.shaded.Request aborted");
        }
        if (proxy == null) {
            localTracker.connectTarget(this.connection.isSecure());
        } else {
            localTracker.connectProxy(proxy, this.connection.isSecure());
        }
    }

    public void tunnelTarget(boolean secure, HttpParams params) throws IOException {
        Args.notNull(params, "io.quarkus.launcher.shaded.HTTP parameters");
        Asserts.notNull(this.tracker, "io.quarkus.launcher.shaded.Route tracker");
        Asserts.check(this.tracker.isConnected(), "io.quarkus.launcher.shaded.Connection not open");
        Asserts.check(!this.tracker.isTunnelled(), "io.quarkus.launcher.shaded.Connection is already tunnelled");
        this.connection.update(null, this.tracker.getTargetHost(), secure, params);
        this.tracker.tunnelTarget(secure);
    }

    public void tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
        Args.notNull(next, "io.quarkus.launcher.shaded.Next proxy");
        Args.notNull(params, "io.quarkus.launcher.shaded.Parameters");
        Asserts.notNull(this.tracker, "io.quarkus.launcher.shaded.Route tracker");
        Asserts.check(this.tracker.isConnected(), "io.quarkus.launcher.shaded.Connection not open");
        this.connection.update(null, next, secure, params);
        this.tracker.tunnelProxy(next, secure);
    }

    public void layerProtocol(HttpContext context, HttpParams params) throws IOException {
        Args.notNull(params, "io.quarkus.launcher.shaded.HTTP parameters");
        Asserts.notNull(this.tracker, "io.quarkus.launcher.shaded.Route tracker");
        Asserts.check(this.tracker.isConnected(), "io.quarkus.launcher.shaded.Connection not open");
        Asserts.check(this.tracker.isTunnelled(), "io.quarkus.launcher.shaded.Protocol layering without a tunnel not supported");
        Asserts.check(!this.tracker.isLayered(), "io.quarkus.launcher.shaded.Multiple protocol layering not supported");
        HttpHost target = this.tracker.getTargetHost();
        this.connOperator.updateSecureConnection(this.connection, target, context, params);
        this.tracker.layerProtocol(this.connection.isSecure());
    }

    protected void shutdownEntry() {
        this.tracker = null;
        this.state = null;
    }
}

