/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.conn;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.HttpClientConnection;
import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.config.ConnectionConfig;
import io.quarkus.launcher.shaded.org.apache.http.config.Lookup;
import io.quarkus.launcher.shaded.org.apache.http.config.Registry;
import io.quarkus.launcher.shaded.org.apache.http.config.RegistryBuilder;
import io.quarkus.launcher.shaded.org.apache.http.config.SocketConfig;
import io.quarkus.launcher.shaded.org.apache.http.conn.ConnectionRequest;
import io.quarkus.launcher.shaded.org.apache.http.conn.DnsResolver;
import io.quarkus.launcher.shaded.org.apache.http.conn.HttpClientConnectionManager;
import io.quarkus.launcher.shaded.org.apache.http.conn.HttpClientConnectionOperator;
import io.quarkus.launcher.shaded.org.apache.http.conn.HttpConnectionFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.ManagedHttpClientConnection;
import io.quarkus.launcher.shaded.org.apache.http.conn.SchemePortResolver;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.HttpRoute;
import io.quarkus.launcher.shaded.org.apache.http.conn.socket.ConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import io.quarkus.launcher.shaded.org.apache.http.protocol.HttpContext;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.Asserts;
import io.quarkus.launcher.shaded.org.apache.http.util.LangUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class BasicHttpClientConnectionManager
implements HttpClientConnectionManager,
Closeable {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    private ManagedHttpClientConnection conn;
    private HttpRoute route;
    private Object state;
    private long updated;
    private long expiry;
    private boolean leased;
    private SocketConfig socketConfig;
    private ConnectionConfig connConfig;
    private final AtomicBoolean isShutdown;

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("io.quarkus.launcher.shaded.http", PlainConnectionSocketFactory.getSocketFactory()).register("io.quarkus.launcher.shaded.https", (PlainConnectionSocketFactory)((Object)SSLConnectionSocketFactory.getSocketFactory())).build();
    }

    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultHttpClientConnectionOperator(socketFactoryRegistry, schemePortResolver, dnsResolver), connFactory);
    }

    public BasicHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
        this.connectionOperator = Args.notNull(httpClientConnectionOperator, "io.quarkus.launcher.shaded.Connection operator");
        this.connFactory = connFactory != null ? connFactory : ManagedHttpClientConnectionFactory.INSTANCE;
        this.expiry = Long.MAX_VALUE;
        this.socketConfig = SocketConfig.DEFAULT;
        this.connConfig = ConnectionConfig.DEFAULT;
        this.isShutdown = new AtomicBoolean(false);
    }

    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
        this(socketFactoryRegistry, connFactory, null, null);
    }

    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry) {
        this(socketFactoryRegistry, null, null, null);
    }

    public BasicHttpClientConnectionManager() {
        this(BasicHttpClientConnectionManager.getDefaultRegistry(), null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.closeConnection();
        }
    }

    HttpRoute getRoute() {
        return this.route;
    }

    Object getState() {
        return this.state;
    }

    public synchronized SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    public synchronized void setSocketConfig(SocketConfig socketConfig) {
        this.socketConfig = socketConfig != null ? socketConfig : SocketConfig.DEFAULT;
    }

    public synchronized ConnectionConfig getConnectionConfig() {
        return this.connConfig;
    }

    public synchronized void setConnectionConfig(ConnectionConfig connConfig) {
        this.connConfig = connConfig != null ? connConfig : ConnectionConfig.DEFAULT;
    }

    @Override
    public final ConnectionRequest requestConnection(final HttpRoute route, final Object state) {
        Args.notNull(route, "io.quarkus.launcher.shaded.Route");
        return new ConnectionRequest(){

            @Override
            public boolean cancel() {
                return false;
            }

            @Override
            public HttpClientConnection get(long timeout, TimeUnit timeUnit) {
                return BasicHttpClientConnectionManager.this.getConnection(route, state);
            }
        };
    }

    private synchronized void closeConnection() {
        if (this.conn != null) {
            block3: {
                this.log.debug("io.quarkus.launcher.shaded.Closing connection");
                try {
                    this.conn.close();
                }
                catch (IOException iox) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("io/quarkus/launcher/shaded/I/O exception closing connection", iox);
                }
            }
            this.conn = null;
        }
    }

    private void checkExpiry() {
        if (this.conn != null && System.currentTimeMillis() >= this.expiry) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("io.quarkus.launcher.shaded.Connection expired @ " + new Date(this.expiry));
            }
            this.closeConnection();
        }
    }

    synchronized HttpClientConnection getConnection(HttpRoute route, Object state) {
        Asserts.check(!this.isShutdown.get(), "io.quarkus.launcher.shaded.Connection manager has been shut down");
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Get connection for route " + route);
        }
        Asserts.check(!this.leased, "io.quarkus.launcher.shaded.Connection is still allocated");
        if (!LangUtils.equals(this.route, route) || !LangUtils.equals(this.state, state)) {
            this.closeConnection();
        }
        this.route = route;
        this.state = state;
        this.checkExpiry();
        if (this.conn == null) {
            this.conn = this.connFactory.create(route, this.connConfig);
        }
        this.conn.setSocketTimeout(this.socketConfig.getSoTimeout());
        this.leased = true;
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void releaseConnection(HttpClientConnection conn, Object state, long keepalive, TimeUnit timeUnit) {
        Args.notNull(conn, "io.quarkus.launcher.shaded.Connection");
        Asserts.check(conn == this.conn, "io.quarkus.launcher.shaded.Connection not obtained from this manager");
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Releasing connection " + conn);
        }
        if (this.isShutdown.get()) {
            return;
        }
        try {
            this.updated = System.currentTimeMillis();
            if (!this.conn.isOpen()) {
                this.conn = null;
                this.route = null;
                this.conn = null;
                this.expiry = Long.MAX_VALUE;
            } else {
                this.state = state;
                this.conn.setSocketTimeout(0);
                if (this.log.isDebugEnabled()) {
                    String s = keepalive > 0L ? "io.quarkus.launcher.shaded.for " + keepalive + "io.quarkus.launcher.shaded. " + (Object)((Object)timeUnit) : "io.quarkus.launcher.shaded.indefinitely";
                    this.log.debug("io.quarkus.launcher.shaded.Connection can be kept alive " + s);
                }
                this.expiry = keepalive > 0L ? this.updated + timeUnit.toMillis(keepalive) : Long.MAX_VALUE;
            }
        }
        finally {
            this.leased = false;
        }
    }

    @Override
    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        Args.notNull(conn, "io.quarkus.launcher.shaded.Connection");
        Args.notNull(route, "io.quarkus.launcher.shaded.HTTP route");
        Asserts.check(conn == this.conn, "io.quarkus.launcher.shaded.Connection not obtained from this manager");
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        this.connectionOperator.connect(this.conn, host, localAddress, connectTimeout, this.socketConfig, context);
    }

    @Override
    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        Args.notNull(conn, "io.quarkus.launcher.shaded.Connection");
        Args.notNull(route, "io.quarkus.launcher.shaded.HTTP route");
        Asserts.check(conn == this.conn, "io.quarkus.launcher.shaded.Connection not obtained from this manager");
        this.connectionOperator.upgrade(this.conn, route.getTargetHost(), context);
    }

    @Override
    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
    }

    @Override
    public synchronized void closeExpiredConnections() {
        if (this.isShutdown.get()) {
            return;
        }
        if (!this.leased) {
            this.checkExpiry();
        }
    }

    @Override
    public synchronized void closeIdleConnections(long idletime, TimeUnit timeUnit) {
        Args.notNull(timeUnit, "io.quarkus.launcher.shaded.Time unit");
        if (this.isShutdown.get()) {
            return;
        }
        if (!this.leased) {
            long deadline;
            long time = timeUnit.toMillis(idletime);
            if (time < 0L) {
                time = 0L;
            }
            if (this.updated <= (deadline = System.currentTimeMillis() - time)) {
                this.closeConnection();
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.isShutdown.compareAndSet(false, true) && this.conn != null) {
            block3: {
                this.log.debug("io.quarkus.launcher.shaded.Shutting down connection");
                try {
                    this.conn.shutdown();
                }
                catch (IOException iox) {
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug("io/quarkus/launcher/shaded/I/O exception shutting down connection", iox);
                }
            }
            this.conn = null;
        }
    }
}

