/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.conn;

import io.quarkus.launcher.shaded.org.apache.http.HttpHost;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.conn.SchemePortResolver;
import io.quarkus.launcher.shaded.org.apache.http.conn.UnsupportedSchemeException;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultSchemePortResolver
implements SchemePortResolver {
    public static final DefaultSchemePortResolver INSTANCE = new DefaultSchemePortResolver();

    @Override
    public int resolve(HttpHost host) throws UnsupportedSchemeException {
        Args.notNull(host, "io.quarkus.launcher.shaded.HTTP host");
        int port = host.getPort();
        if (port > 0) {
            return port;
        }
        String name = host.getSchemeName();
        if (name.equalsIgnoreCase("io.quarkus.launcher.shaded.http")) {
            return 80;
        }
        if (name.equalsIgnoreCase("io.quarkus.launcher.shaded.https")) {
            return 443;
        }
        throw new UnsupportedSchemeException(name + "io.quarkus.launcher.shaded. protocol is not supported");
    }
}

