/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.conn;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.conn.DnsResolver;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryDnsResolver
implements DnsResolver {
    private final Log log = LogFactory.getLog(InMemoryDnsResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new ConcurrentHashMap<String, InetAddress[]>();

    public void add(String host, InetAddress ... ips) {
        Args.notNull(host, "io.quarkus.launcher.shaded.Host name");
        Args.notNull(ips, "io.quarkus.launcher.shaded.Array of IP addresses");
        this.dnsMap.put(host, ips);
    }

    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        Object[] resolvedAddresses = this.dnsMap.get(host);
        if (this.log.isInfoEnabled()) {
            this.log.info("io.quarkus.launcher.shaded.Resolving " + host + "io.quarkus.launcher.shaded. to " + Arrays.deepToString(resolvedAddresses));
        }
        if (resolvedAddresses == null) {
            throw new UnknownHostException(host + "io.quarkus.launcher.shaded. cannot be resolved");
        }
        return resolvedAddresses;
    }
}

