/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.conn;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class Wire {
    private final Log log;
    private final String id;

    public Wire(Log log, String id) {
        this.log = log;
        this.id = id;
    }

    public Wire(Log log) {
        this(log, "io.quarkus.launcher.shaded.");
    }

    private void wire(String header, InputStream inStream) throws IOException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while ((ch = inStream.read()) != -1) {
            if (ch == 13) {
                buffer.append("io.quarkus.launcher.shaded.[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("io.quarkus.launcher.shaded.[\\n]\"");
                buffer.insert(0, "io.quarkus.launcher.shaded.\"");
                buffer.insert(0, header);
                this.log.debug(this.id + "io.quarkus.launcher.shaded. " + buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("io.quarkus.launcher.shaded.[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("io.quarkus.launcher.shaded.]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, header);
            this.log.debug(this.id + "io.quarkus.launcher.shaded. " + buffer.toString());
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    public void output(InputStream outStream) throws IOException {
        Args.notNull(outStream, "io.quarkus.launcher.shaded.Output");
        this.wire("io.quarkus.launcher.shaded.>> ", outStream);
    }

    public void input(InputStream inStream) throws IOException {
        Args.notNull(inStream, "io.quarkus.launcher.shaded.Input");
        this.wire("io.quarkus.launcher.shaded.<< ", inStream);
    }

    public void output(byte[] b, int off, int len) throws IOException {
        Args.notNull(b, "io.quarkus.launcher.shaded.Output");
        this.wire("io.quarkus.launcher.shaded.>> ", new ByteArrayInputStream(b, off, len));
    }

    public void input(byte[] b, int off, int len) throws IOException {
        Args.notNull(b, "io.quarkus.launcher.shaded.Input");
        this.wire("io.quarkus.launcher.shaded.<< ", new ByteArrayInputStream(b, off, len));
    }

    public void output(byte[] b) throws IOException {
        Args.notNull(b, "io.quarkus.launcher.shaded.Output");
        this.wire("io.quarkus.launcher.shaded.>> ", new ByteArrayInputStream(b));
    }

    public void input(byte[] b) throws IOException {
        Args.notNull(b, "io.quarkus.launcher.shaded.Input");
        this.wire("io.quarkus.launcher.shaded.<< ", new ByteArrayInputStream(b));
    }

    public void output(int b) throws IOException {
        this.output(new byte[]{(byte)b});
    }

    public void input(int b) throws IOException {
        this.input(new byte[]{(byte)b});
    }

    public void output(String s) throws IOException {
        Args.notNull(s, "io.quarkus.launcher.shaded.Output");
        this.output(s.getBytes());
    }

    public void input(String s) throws IOException {
        Args.notNull(s, "io.quarkus.launcher.shaded.Input");
        this.input(s.getBytes());
    }
}

