/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.conn.tsccm;

import io.quarkus.launcher.shaded.org.apache.commons.logging.Log;
import io.quarkus.launcher.shaded.org.apache.commons.logging.LogFactory;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.conn.ClientConnectionManager;
import io.quarkus.launcher.shaded.org.apache.http.conn.ClientConnectionOperator;
import io.quarkus.launcher.shaded.org.apache.http.conn.ClientConnectionRequest;
import io.quarkus.launcher.shaded.org.apache.http.conn.ConnectionPoolTimeoutException;
import io.quarkus.launcher.shaded.org.apache.http.conn.ManagedClientConnection;
import io.quarkus.launcher.shaded.org.apache.http.conn.params.ConnPerRouteBean;
import io.quarkus.launcher.shaded.org.apache.http.conn.routing.HttpRoute;
import io.quarkus.launcher.shaded.org.apache.http.conn.scheme.SchemeRegistry;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.AbstractPoolEntry;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.DefaultClientConnectionOperator;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.SchemeRegistryFactory;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.tsccm.AbstractConnPool;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import io.quarkus.launcher.shaded.org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import io.quarkus.launcher.shaded.org.apache.http.params.HttpParams;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.Asserts;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ThreadSafeClientConnManager
implements ClientConnectionManager {
    private final Log log;
    protected final SchemeRegistry schemeRegistry;
    protected final AbstractConnPool connectionPool;
    protected final ConnPoolByRoute pool;
    protected final ClientConnectionOperator connOperator;
    protected final ConnPerRouteBean connPerRoute;

    public ThreadSafeClientConnManager(SchemeRegistry schreg) {
        this(schreg, -1L, TimeUnit.MILLISECONDS);
    }

    public ThreadSafeClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    public ThreadSafeClientConnManager(SchemeRegistry schreg, long connTTL, TimeUnit connTTLTimeUnit) {
        this(schreg, connTTL, connTTLTimeUnit, new ConnPerRouteBean());
    }

    public ThreadSafeClientConnManager(SchemeRegistry schreg, long connTTL, TimeUnit connTTLTimeUnit, ConnPerRouteBean connPerRoute) {
        Args.notNull(schreg, "io.quarkus.launcher.shaded.Scheme registry");
        this.log = LogFactory.getLog(this.getClass());
        this.schemeRegistry = schreg;
        this.connPerRoute = connPerRoute;
        this.connOperator = this.createConnectionOperator(schreg);
        this.pool = this.createConnectionPool(connTTL, connTTLTimeUnit);
        this.connectionPool = this.pool;
    }

    @Deprecated
    public ThreadSafeClientConnManager(HttpParams params, SchemeRegistry schreg) {
        Args.notNull(schreg, "io.quarkus.launcher.shaded.Scheme registry");
        this.log = LogFactory.getLog(this.getClass());
        this.schemeRegistry = schreg;
        this.connPerRoute = new ConnPerRouteBean();
        this.connOperator = this.createConnectionOperator(schreg);
        this.pool = (ConnPoolByRoute)this.createConnectionPool(params);
        this.connectionPool = this.pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        finally {
            super.finalize();
        }
    }

    @Deprecated
    protected AbstractConnPool createConnectionPool(HttpParams params) {
        return new ConnPoolByRoute(this.connOperator, params);
    }

    protected ConnPoolByRoute createConnectionPool(long connTTL, TimeUnit connTTLTimeUnit) {
        return new ConnPoolByRoute(this.connOperator, this.connPerRoute, 20, connTTL, connTTLTimeUnit);
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    @Override
    public ClientConnectionRequest requestConnection(final HttpRoute route, Object state) {
        final PoolEntryRequest poolRequest = this.pool.requestPoolEntry(route, state);
        return new ClientConnectionRequest(){

            @Override
            public void abortRequest() {
                poolRequest.abortRequest();
            }

            @Override
            public ManagedClientConnection getConnection(long timeout, TimeUnit timeUnit) throws InterruptedException, ConnectionPoolTimeoutException {
                Args.notNull(route, "io.quarkus.launcher.shaded.Route");
                if (ThreadSafeClientConnManager.this.log.isDebugEnabled()) {
                    ThreadSafeClientConnManager.this.log.debug("io.quarkus.launcher.shaded.Get connection: " + route + "io.quarkus.launcher.shaded., timeout = " + timeout);
                }
                BasicPoolEntry entry = poolRequest.getPoolEntry(timeout, timeUnit);
                return new BasicPooledConnAdapter(ThreadSafeClientConnManager.this, (AbstractPoolEntry)entry);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
        Args.check(conn instanceof BasicPooledConnAdapter, "io.quarkus.launcher.shaded.Connection class mismatch, connection not obtained from this manager");
        BasicPooledConnAdapter hca = (BasicPooledConnAdapter)conn;
        if (hca.getPoolEntry() != null) {
            Asserts.check(hca.getManager() == this, "io.quarkus.launcher.shaded.Connection not obtained from this manager");
        }
        BasicPooledConnAdapter basicPooledConnAdapter = hca;
        synchronized (basicPooledConnAdapter) {
            BasicPoolEntry entry = (BasicPoolEntry)hca.getPoolEntry();
            if (entry == null) {
                return;
            }
            try {
                if (hca.isOpen() && !hca.isMarkedReusable()) {
                    hca.shutdown();
                }
            }
            catch (IOException iox) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("io.quarkus.launcher.shaded.Exception shutting down released connection.", iox);
                }
            }
            finally {
                boolean reusable = hca.isMarkedReusable();
                if (this.log.isDebugEnabled()) {
                    if (reusable) {
                        this.log.debug("io.quarkus.launcher.shaded.Released connection is reusable.");
                    } else {
                        this.log.debug("io.quarkus.launcher.shaded.Released connection is not reusable.");
                    }
                }
                hca.detach();
                this.pool.freeEntry(entry, reusable, validDuration, timeUnit);
            }
        }
    }

    @Override
    public void shutdown() {
        this.log.debug("io.quarkus.launcher.shaded.Shutting down");
        this.pool.shutdown();
    }

    public int getConnectionsInPool(HttpRoute route) {
        return this.pool.getConnectionsInPool(route);
    }

    public int getConnectionsInPool() {
        return this.pool.getConnectionsInPool();
    }

    @Override
    public void closeIdleConnections(long idleTimeout, TimeUnit timeUnit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("io.quarkus.launcher.shaded.Closing connections idle longer than " + idleTimeout + "io.quarkus.launcher.shaded. " + (Object)((Object)timeUnit));
        }
        this.pool.closeIdleConnections(idleTimeout, timeUnit);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug("io.quarkus.launcher.shaded.Closing expired connections");
        this.pool.closeExpiredConnections();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotalConnections();
    }

    public void setMaxTotal(int max) {
        this.pool.setMaxTotalConnections(max);
    }

    public int getDefaultMaxPerRoute() {
        return this.connPerRoute.getDefaultMaxPerRoute();
    }

    public void setDefaultMaxPerRoute(int max) {
        this.connPerRoute.setDefaultMaxPerRoute(max);
    }

    public int getMaxForRoute(HttpRoute route) {
        return this.connPerRoute.getMaxForRoute(route);
    }

    public void setMaxForRoute(HttpRoute route, int max) {
        this.connPerRoute.setMaxForRoute(route, max);
    }
}

