/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.conn.util.InetAddressUtils;
import io.quarkus.launcher.shaded.org.apache.http.cookie.ClientCookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieRestrictionViolationException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.TextUtils;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicDomainHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (TextUtils.isBlank(value)) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Blank or null value for domain attribute");
        }
        if (value.endsWith("io.quarkus.launcher.shaded..")) {
            return;
        }
        String domain = value;
        if (domain.startsWith("io.quarkus.launcher.shaded..")) {
            domain = domain.substring(1);
        }
        domain = domain.toLowerCase(Locale.ROOT);
        cookie.setDomain(domain);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Cookie 'domain' may not be null");
        }
        if (!host.equals(domain) && !BasicDomainHandler.domainMatch(domain, host)) {
            throw new CookieRestrictionViolationException("io.quarkus.launcher.shaded.Illegal 'domain' attribute \"" + domain + "io.quarkus.launcher.shaded.\". Domain of origin: \"" + host + "io.quarkus.launcher.shaded.\"");
        }
    }

    static boolean domainMatch(String domain, String host) {
        String normalizedDomain;
        if (InetAddressUtils.isIPv4Address(host) || InetAddressUtils.isIPv6Address(host)) {
            return false;
        }
        String string = normalizedDomain = domain.startsWith("io.quarkus.launcher.shaded..") ? domain.substring(1) : domain;
        if (host.endsWith(normalizedDomain)) {
            int prefix = host.length() - normalizedDomain.length();
            if (prefix == 0) {
                return true;
            }
            if (prefix > 1 && host.charAt(prefix - 1) == '.') {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        if (domain.startsWith("io.quarkus.launcher.shaded..")) {
            domain = domain.substring(1);
        }
        if (host.equals(domain = domain.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("io.quarkus.launcher.shaded.domain")) {
            return BasicDomainHandler.domainMatch(domain, host);
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.domain";
    }
}

