/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.client.utils.DateUtils;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicExpiresHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    private final String[] datepatterns;

    public BasicExpiresHandler(String[] datepatterns) {
        Args.notNull(datepatterns, "io.quarkus.launcher.shaded.Array of date patterns");
        this.datepatterns = datepatterns;
    }

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (value == null) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Missing value for 'expires' attribute");
        }
        Date expiry = DateUtils.parseDate(value, this.datepatterns);
        if (expiry == null) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Invalid 'expires' attribute: " + value);
        }
        cookie.setExpiryDate(expiry);
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.expires";
    }
}

