/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CommonCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.cookie.SetCookie;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import java.util.Date;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicMaxAgeHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        int age;
        Args.notNull(cookie, "io.quarkus.launcher.shaded.Cookie");
        if (value == null) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Missing value for 'max-age' attribute");
        }
        try {
            age = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Invalid 'max-age' attribute: " + value);
        }
        if (age < 0) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Negative 'max-age' attribute: " + value);
        }
        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
    }

    @Override
    public String getAttributeName() {
        return "io.quarkus.launcher.shaded.max-age";
    }
}

