/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher.shaded.org.apache.http.impl.cookie;

import io.quarkus.launcher.shaded.org.apache.http.FormattedHeader;
import io.quarkus.launcher.shaded.org.apache.http.Header;
import io.quarkus.launcher.shaded.org.apache.http.HeaderElement;
import io.quarkus.launcher.shaded.org.apache.http.NameValuePair;
import io.quarkus.launcher.shaded.org.apache.http.annotation.Contract;
import io.quarkus.launcher.shaded.org.apache.http.annotation.ThreadingBehavior;
import io.quarkus.launcher.shaded.org.apache.http.cookie.Cookie;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.cookie.CookieOrigin;
import io.quarkus.launcher.shaded.org.apache.http.cookie.MalformedCookieException;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicClientCookie;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicCommentHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicDomainHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicExpiresHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicMaxAgeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicPathHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BasicSecureHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.BrowserCompatVersionAttributeHandler;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.CookieSpecBase;
import io.quarkus.launcher.shaded.org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHeaderElement;
import io.quarkus.launcher.shaded.org.apache.http.message.BasicHeaderValueFormatter;
import io.quarkus.launcher.shaded.org.apache.http.message.BufferedHeader;
import io.quarkus.launcher.shaded.org.apache.http.message.ParserCursor;
import io.quarkus.launcher.shaded.org.apache.http.util.Args;
import io.quarkus.launcher.shaded.org.apache.http.util.CharArrayBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE)
public class BrowserCompatSpec
extends CookieSpecBase {
    private static final String[] DEFAULT_DATE_PATTERNS = new String[]{"io.quarkus.launcher.shaded.EEE, dd MMM yyyy HH:mm:ss zzz", "io.quarkus.launcher.shaded.EEE, dd-MMM-yy HH:mm:ss zzz", "io.quarkus.launcher.shaded.EEE MMM d HH:mm:ss yyyy", "io.quarkus.launcher.shaded.EEE, dd-MMM-yyyy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE, dd-MMM-yyyy HH-mm-ss z", "io.quarkus.launcher.shaded.EEE, dd MMM yy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE dd-MMM-yyyy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE dd MMM yyyy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE dd-MMM-yyyy HH-mm-ss z", "io.quarkus.launcher.shaded.EEE dd-MMM-yy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE dd MMM yy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE,dd-MMM-yy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE,dd-MMM-yyyy HH:mm:ss z", "io.quarkus.launcher.shaded.EEE, dd-MM-yyyy HH:mm:ss z"};

    public BrowserCompatSpec(String[] datepatterns, BrowserCompatSpecFactory.SecurityLevel securityLevel) {
        super(new BrowserCompatVersionAttributeHandler(), new BasicDomainHandler(), securityLevel == BrowserCompatSpecFactory.SecurityLevel.SECURITYLEVEL_IE_MEDIUM ? new BasicPathHandler(){

            @Override
            public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
            }
        } : new BasicPathHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(datepatterns != null ? (String[])datepatterns.clone() : DEFAULT_DATE_PATTERNS));
    }

    public BrowserCompatSpec(String[] datepatterns) {
        this(datepatterns, BrowserCompatSpecFactory.SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    public BrowserCompatSpec() {
        this(null, BrowserCompatSpecFactory.SecurityLevel.SECURITYLEVEL_DEFAULT);
    }

    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(header, "io.quarkus.launcher.shaded.Header");
        Args.notNull(origin, "io.quarkus.launcher.shaded.Cookie origin");
        String headername = header.getName();
        if (!headername.equalsIgnoreCase("io.quarkus.launcher.shaded.Set-Cookie")) {
            throw new MalformedCookieException("io.quarkus.launcher.shaded.Unrecognized cookie header '" + header.toString() + "io.quarkus.launcher.shaded.'");
        }
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        for (HeaderElement helem : helems) {
            if (helem.getParameterByName("io.quarkus.launcher.shaded.version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("io.quarkus.launcher.shaded.expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedCookieException("io.quarkus.launcher.shaded.Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                cursor = new ParserCursor(0, buffer.length());
            }
            HeaderElement elem = parser.parseHeader(buffer, cursor);
            String name = elem.getName();
            String value = elem.getValue();
            if (name == null || name.isEmpty()) {
                throw new MalformedCookieException("io.quarkus.launcher.shaded.Cookie name may not be empty");
            }
            BasicClientCookie cookie = new BasicClientCookie(name, value);
            cookie.setPath(BrowserCompatSpec.getDefaultPath(origin));
            cookie.setDomain(BrowserCompatSpec.getDefaultDomain(origin));
            NameValuePair[] attribs = elem.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase(Locale.ROOT);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            if (netscape) {
                cookie.setVersion(0);
            }
            return Collections.singletonList(cookie);
        }
        return this.parse(helems, origin);
    }

    private static boolean isQuoteEnclosed(String s) {
        return s != null && s.startsWith("io.quarkus.launcher.shaded.\"") && s.endsWith("io.quarkus.launcher.shaded.\"");
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        Args.notEmpty(cookies, "io.quarkus.launcher.shaded.List of cookies");
        CharArrayBuffer buffer = new CharArrayBuffer(20 * cookies.size());
        buffer.append("io.quarkus.launcher.shaded.Cookie");
        buffer.append("io.quarkus.launcher.shaded.: ");
        for (int i = 0; i < cookies.size(); ++i) {
            Cookie cookie = cookies.get(i);
            if (i > 0) {
                buffer.append("io.quarkus.launcher.shaded.; ");
            }
            String cookieName = cookie.getName();
            String cookieValue = cookie.getValue();
            if (cookie.getVersion() > 0 && !BrowserCompatSpec.isQuoteEnclosed(cookieValue)) {
                BasicHeaderValueFormatter.INSTANCE.formatHeaderElement(buffer, new BasicHeaderElement(cookieName, cookieValue), false);
                continue;
            }
            buffer.append(cookieName);
            buffer.append("io.quarkus.launcher.shaded.=");
            if (cookieValue == null) continue;
            buffer.append(cookieValue);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    @Override
    public int getVersion() {
        return 0;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "io.quarkus.launcher.shaded.compatibility";
    }
}

